/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.triples.IndexedTriple;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;

public class CompressTripleWriter
implements Closeable {
    private final CRCOutputStream out;

    public CompressTripleWriter(OutputStream writer) {
        this.out = new CRCOutputStream(writer, new CRC32());
    }

    public void appendTriple(IndexedTriple triple) throws IOException {
        VByte.encode(this.out, triple.getSubject().getIndex());
        VByte.encode(this.out, triple.getPredicate().getIndex());
        VByte.encode(this.out, triple.getObject().getIndex());
    }

    public void appendTriple(TripleID triple) throws IOException {
        VByte.encode(this.out, triple.getSubject());
        VByte.encode(this.out, triple.getPredicate());
        VByte.encode(this.out, triple.getObject());
    }

    public void writeCRC() throws IOException {
        VByte.encode(this.out, 0L);
        VByte.encode(this.out, 0L);
        VByte.encode(this.out, 0L);
        this.out.writeCRC();
    }

    @Override
    public void close() throws IOException {
        this.writeCRC();
        this.out.close();
    }
}

