/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRCInputStream;

public class CompressTripleReader
implements ExceptionIterator<TripleID, IOException>,
Closeable {
    private final CRCInputStream stream;
    private final TripleID next = new TripleID(-1L, -1L, -1L);
    private boolean read = false;
    private boolean end = false;

    public CompressTripleReader(InputStream stream) {
        this.stream = new CRCInputStream(stream, new CRC32());
    }

    @Override
    public boolean hasNext() throws IOException {
        long o;
        long p;
        long s;
        if (this.read) {
            return true;
        }
        if (this.end) {
            return false;
        }
        do {
            s = VByte.decode(this.stream);
            p = VByte.decode(this.stream);
            o = VByte.decode(this.stream);
        } while (s == this.next.getSubject() && p == this.next.getPredicate() && o == this.next.getObject());
        return !this.setAllOrEnd(s, p, o);
    }

    private boolean setAllOrEnd(long s, long p, long o) throws IOException {
        if (this.end) {
            return true;
        }
        if (s == 0L || p == 0L || o == 0L) {
            if (s != 0L || p != 0L || o != 0L) {
                throw new IOException("Triple got null node, but not all the nodes are 0! " + s + " " + p + " " + o);
            }
            if (!this.stream.readCRCAndCheck()) {
                throw new CRCException("CRC Error while reading PreMapped triples.");
            }
            this.end = true;
            return true;
        }
        this.next.setAll(s, p, o);
        this.read = true;
        return false;
    }

    @Override
    public TripleID next() throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        this.read = false;
        return this.next;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

