/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class CompressNodeWriter
implements Closeable {
    private final CRCOutputStream out;
    private final ReplazableString previousStr = new ReplazableString();

    public CompressNodeWriter(OutputStream stream, long size) throws IOException {
        this.out = new CRCOutputStream(stream, new CRC8());
        VByte.encode(this.out, size);
        this.out.writeCRC();
        this.out.setCRC(new CRC32());
    }

    public void appendNode(IndexedNode node) throws IOException {
        ByteString str = node.getNode();
        long index = node.getIndex();
        int delta = ByteStringUtil.longestCommonPrefix(this.previousStr, str);
        VByte.encode(this.out, delta);
        ByteStringUtil.append((OutputStream)this.out, str, delta);
        this.out.write(0);
        VByte.encode(this.out, index);
        this.previousStr.replace(str);
    }

    public void writeCRC() throws IOException {
        this.out.writeCRC();
    }

    @Override
    public void close() throws IOException {
        this.writeCRC();
        this.out.close();
    }
}

