/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.IndexNodeDeltaMergeExceptionIterator;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.string.ReplazableString;
import org.rdfhdt.hdt.utils.DebugOrderNodeIterator;

public class CompressNodeReader
implements ExceptionIterator<IndexedNode, IOException>,
IndexNodeDeltaMergeExceptionIterator.IndexNodeDeltaFetcher<IOException>,
Closeable {
    private final CRCInputStream stream;
    private final long size;
    private long index;
    private int delta;
    private boolean waiting;
    private final IndexedNode last;
    private final ReplazableString tempString;
    private final Consumer<IndexedNode> consumer;

    public CompressNodeReader(InputStream stream) throws IOException {
        this.stream = new CRCInputStream(stream, new CRC8());
        this.size = VByte.decode(this.stream);
        if (!this.stream.readCRCAndCheck()) {
            throw new CRCException("CRC Error while merging Section Plain Front Coding Header.");
        }
        this.stream.setCRC(new CRC32());
        this.tempString = new ReplazableString();
        this.last = new IndexedNode(this.tempString, -1L);
        this.consumer = DebugOrderNodeIterator.of("stream", true);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void checkComplete() throws IOException {
        if (!this.stream.readCRCAndCheck()) {
            throw new CRCException("CRC Error while merging Section Plain Front Coding Header.");
        }
    }

    public IndexedNode read() throws IOException {
        if (this.waiting) {
            return this.last;
        }
        this.delta = (int)VByte.decode(this.stream);
        this.tempString.replace2(this.stream, this.delta);
        long index = VByte.decode(this.stream);
        this.last.setIndex(index);
        this.consumer.accept(this.last);
        this.waiting = true;
        return this.last;
    }

    public void pass() {
        this.waiting = false;
        ++this.index;
    }

    @Override
    public IndexedNode next() throws IOException {
        IndexedNode node = this.read();
        this.pass();
        return node;
    }

    @Override
    public IndexedNode fetchNode() throws IOException {
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    @Override
    public int lastDelta() {
        return this.delta;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.index < this.size;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

