/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.enums.CompressionType;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.unsafe.MemoryUtils;
import org.rdfhdt.hdt.unsafe.UnsafeLongArray;
import org.rdfhdt.hdt.util.io.CloseMappedByteBuffer;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public class IOUtil {
    private IOUtil() {
    }

    public static void cleanBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        MemoryUtils.getUnsafe().invokeCleaner(buffer);
    }

    public static void closeObject(Object object) throws IOException {
        if (object instanceof Closeable) {
            ((Closeable)object).close();
        }
    }

    public static CloseMappedByteBuffer mapChannel(String filename, FileChannel ch, FileChannel.MapMode mode, long position, long size) throws IOException {
        return new CloseMappedByteBuffer(filename, ch.map(mode, position, size), false);
    }

    public static UnsafeLongArray createLargeArray(long size) {
        return IOUtil.createLargeArray(size, true);
    }

    public static UnsafeLongArray createLargeArray(long size, boolean init) {
        return UnsafeLongArray.allocate(size, init);
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        if (closeables == null || closeables.length == 0) {
            return;
        }
        if (closeables.length == 1) {
            if (closeables[0] != null) {
                closeables[0].close();
            }
            return;
        }
        IOUtil.closeAll(Arrays.asList(closeables));
    }

    public static void closeAll(Iterable<? extends Closeable> closeables) throws IOException {
        Throwable start = null;
        ArrayList<Throwable> throwableList = null;
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (start != null) {
                    if (throwableList == null) {
                        throwableList = new ArrayList<Throwable>();
                        throwableList.add(start);
                    }
                    throwableList.add(e);
                    continue;
                }
                start = e;
            }
        }
        if (start == null) {
            return;
        }
        if (throwableList == null) {
            IOUtil.throwIOOrRuntime(start);
            return;
        }
        Throwable main = throwableList.stream().max(Comparator.comparing(t -> {
            if (t instanceof Error) {
                return 2;
            }
            if (t instanceof RuntimeException) {
                return 1;
            }
            return 0;
        })).orElseThrow();
        throwableList.stream().filter(t -> t != main).forEach(main::addSuppressed);
        IOUtil.throwIOOrRuntime(main);
    }

    public static void throwIOOrRuntime(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static InputStream getFileInputStream(String fileName) throws IOException {
        return IOUtil.getFileInputStream(fileName, true);
    }

    public static InputStream getFileInputStream(String fileName, boolean uncompress) throws IOException {
        InputStream input;
        String name = fileName.toLowerCase();
        if (name.startsWith("http:/") || name.startsWith("https:/") || name.startsWith("ftp:/")) {
            URL url = new URL(fileName);
            URLConnection con = url.openConnection();
            con.connect();
            input = con.getInputStream();
        } else {
            input = name.equals("-") ? new BufferedInputStream(System.in) : new BufferedInputStream(new FileInputStream(fileName));
        }
        if (uncompress) {
            if (name.endsWith(".gz") || name.endsWith(".tgz")) {
                input = new GZIPInputStream(input);
            } else if (name.endsWith("bz2") || name.endsWith("bz")) {
                input = new BZip2CompressorInputStream(input, true);
            } else if (name.endsWith("xz")) {
                input = new XZCompressorInputStream(input, true);
            }
        }
        return input;
    }

    public static BufferedReader getFileReader(String fileName) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtil.getFileInputStream(fileName)));
    }

    public static String readLine(InputStream in, char character) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while (true) {
            int value;
            if ((value = in.read()) == -1) {
                throw new EOFException();
            }
            if (value == character) break;
            buf.write(value);
        }
        return buf.toString();
    }

    public static String readChars(InputStream in, int numChars) throws IOException {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            int c = in.read();
            if (c == -1) {
                throw new EOFException();
            }
            out.append((char)c);
        }
        return out.toString();
    }

    public static void writeString(OutputStream out, String str) throws IOException {
        out.write(str.getBytes(ByteStringUtil.STRING_ENCODING));
    }

    public static void writeSizedBuffer(OutputStream output, byte[] buffer, ProgressListener listener) throws IOException {
        IOUtil.writeSizedBuffer(output, buffer, 0, buffer.length, listener);
    }

    public static void writeSizedBuffer(OutputStream output, ByteString str, ProgressListener listener) throws IOException {
        IOUtil.writeSizedBuffer(output, str.getBuffer(), 0, str.length(), listener);
    }

    public static void writeSizedBuffer(OutputStream output, byte[] buffer, int offset, int length, ProgressListener listener) throws IOException {
        VByte.encode(output, length);
        output.write(buffer, offset, length);
    }

    public static void writeBuffer(OutputStream output, byte[] buffer, int offset, int length, ProgressListener listener) throws IOException {
        output.write(buffer, offset, length);
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[0x100000];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static void copyStream(InputStream in, OutputStream out, long n) throws IOException {
        byte[] buffer = new byte[0x100000];
        int len = (int)((long)buffer.length < n ? (long)buffer.length : n);
        long total = 0L;
        while (total < n && (len = in.read(buffer, 0, len)) != -1) {
            out.write(buffer, 0, len);
            len = (int)((total += (long)len) + (long)buffer.length > n ? n - total : (long)buffer.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        try {
            IOUtil.copyStream(in, out);
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(out);
        }
    }

    public static void moveFile(File src, File dst) throws IOException {
        IOUtil.copyFile(src, dst);
        Files.deleteIfExists(src.toPath());
    }

    public static void decompressGzip(File src, File trgt) throws IOException {
        try (GZIPInputStream in = new GZIPInputStream(new BufferedInputStream(new FileInputStream(src)));){
            Files.copy(in, trgt.toPath(), new CopyOption[0]);
        }
    }

    public static void writeLong(OutputStream output, long value) throws IOException {
        byte[] writeBuffer = new byte[8];
        writeBuffer[7] = (byte)(value >>> 56);
        writeBuffer[6] = (byte)(value >>> 48);
        writeBuffer[5] = (byte)(value >>> 40);
        writeBuffer[4] = (byte)(value >>> 32);
        writeBuffer[3] = (byte)(value >>> 24);
        writeBuffer[2] = (byte)(value >>> 16);
        writeBuffer[1] = (byte)(value >>> 8);
        writeBuffer[0] = (byte)value;
        output.write(writeBuffer, 0, 8);
    }

    public static long readLong(InputStream input) throws IOException {
        int count;
        byte[] readBuffer = new byte[8];
        for (int n = 0; n < 8; n += count) {
            count = input.read(readBuffer, n, 8 - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)(readBuffer[0] & 0xFF);
    }

    public static void writeInt(OutputStream output, int value) throws IOException {
        byte[] writeBuffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        output.write(writeBuffer, 0, 4);
    }

    public static byte[] intToByteArray(int value) {
        byte[] writeBuffer = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return writeBuffer;
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }

    public static int byteArrayToInt(byte[] value) {
        return (value[3] << 24) + (value[2] << 16) + (value[1] << 8) + value[0];
    }

    public static byte[] readSizedBuffer(InputStream input, ProgressListener listener) throws IOException {
        long size = VByte.decode(input);
        if (size > 0x7FFFFFFAL || size < 0L) {
            throw new IOException("Read bad sized buffer: " + size);
        }
        return IOUtil.readBuffer(input, (int)size, listener);
    }

    public static byte[] readBuffer(InputStream input, int length, ProgressListener listener) throws IOException {
        int nRead;
        int pos = 0;
        byte[] data = new byte[length];
        while ((nRead = input.read(data, pos, length - pos)) > 0) {
            pos += nRead;
        }
        if (pos != length) {
            throw new EOFException("EOF while reading array from InputStream");
        }
        return data;
    }

    public static CharSequence toBinaryString(long val) {
        StringBuilder str = new StringBuilder(64);
        int bits = 64;
        while (bits-- != 0) {
            str.append((val >>> bits & 1L) != 0L ? (char)'1' : '0');
        }
        return str;
    }

    public static CharSequence toBinaryString(int val) {
        StringBuilder str = new StringBuilder(32);
        int bits = 32;
        while (bits-- != 0) {
            str.append((val >>> bits & 1) != 0 ? (char)'1' : '0');
        }
        return str;
    }

    public static void printBitsln(long val, int bits) {
        IOUtil.printBits(val, bits);
        System.out.println();
    }

    public static void printBits(long val, int bits) {
        while (bits-- != 0) {
            System.out.print((val >>> bits & 1L) != 0L ? (char)'1' : '0');
        }
    }

    public static short readShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch2 << 8) + ch1);
    }

    public static void writeShort(OutputStream out, short value) throws IOException {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
    }

    public static byte readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return (byte)(b & 0xFF);
    }

    public static void writeByte(OutputStream out, byte value) throws IOException {
        out.write(value);
    }

    public static void skip(InputStream in, long n) throws IOException {
        if (n == 0L) {
            return;
        }
        for (long totalSkipped = in.skip(n); totalSkipped < n; totalSkipped += in.skip(n - totalSkipped)) {
        }
    }

    public static void closeQuietly(Closeable output) {
        if (output == null) {
            return;
        }
        try {
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream asUncompressed(InputStream inputStream, CompressionType type) throws IOException {
        switch (type) {
            case GZIP: {
                return new GZIPInputStream(inputStream);
            }
            case BZIP: {
                return new BZip2CompressorInputStream(inputStream, true);
            }
            case XZ: {
                return new XZCompressorInputStream(inputStream, true);
            }
            case NONE: {
                return inputStream;
            }
        }
        throw new IllegalArgumentException("CompressionType not yet implemented: " + type);
    }

    public static void deleteDirRecurse(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

