/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.rdfhdt.hdt.util.io.IOUtil;

public class Closer
implements Iterable<Closeable>,
Closeable {
    private final List<Closeable> list;

    private Closer(Object ... other) {
        this.list = new ArrayList<Closeable>(other.length);
        this.with(other, new Object[0]);
    }

    public static Closer of(Object ... other) {
        return new Closer(other);
    }

    public static void closeAll(Object ... other) throws IOException {
        Closer.of(other).close();
    }

    public Closer with(Object other, Object ... otherList) {
        Stream.concat(Stream.of(other), Arrays.stream(otherList)).flatMap(this::explore).forEach(this.list::add);
        return this;
    }

    private Stream<Closeable> explore(Object obj) {
        if (obj instanceof Closeable) {
            return Stream.of((Closeable)obj);
        }
        if (obj instanceof Iterable) {
            return StreamSupport.stream(((Iterable)obj).spliterator(), false).flatMap(this::explore);
        }
        if (obj instanceof Object[]) {
            return Stream.of((Object[])obj).flatMap(this::explore);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return Stream.concat(this.explore(map.keySet()), this.explore(map.values()));
        }
        return Stream.of(new Closeable[0]);
    }

    @Override
    public Iterator<Closeable> iterator() {
        return this.list.iterator();
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.list);
    }
}

