/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.rdfhdt.hdt.util.io.CloseSuppressFileSystem;
import org.rdfhdt.hdt.util.io.IOUtil;

public class CloseSuppressPath
implements Path,
Closeable {
    public static final int BUFFER_SIZE = 8192;
    private final Path wrapper;
    private boolean isDir;

    CloseSuppressPath(Path wrapper) {
        this.wrapper = wrapper;
    }

    public static CloseSuppressPath of(String first, String ... more) {
        return new CloseSuppressPath(Path.of(first, more));
    }

    public static CloseSuppressPath of(Path component) {
        return component instanceof CloseSuppressPath ? (CloseSuppressPath)component : new CloseSuppressPath(component);
    }

    private static Path extract(Path other) {
        return other instanceof CloseSuppressPath ? ((CloseSuppressPath)other).getJavaPath() : other;
    }

    public static Iterable<Path> of(Iterable<Path> component) {
        return () -> CloseSuppressPath.of(component.iterator());
    }

    public static Iterator<Path> of(final Iterator<Path> it) {
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CloseSuppressPath next() {
                return CloseSuppressPath.of((Path)it.next());
            }

            @Override
            public void remove() {
                it.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super Path> action) {
                it.forEachRemaining((? super E p) -> action.accept(CloseSuppressPath.of(p)));
            }
        };
    }

    public static Path unpack(Path other) {
        return other instanceof CloseSuppressPath ? CloseSuppressPath.unpack(((CloseSuppressPath)other).getJavaPath()) : other;
    }

    @Override
    public FileSystem getFileSystem() {
        return new CloseSuppressFileSystem(this.wrapper.getFileSystem());
    }

    @Override
    public boolean isAbsolute() {
        return this.wrapper.isAbsolute();
    }

    @Override
    public CloseSuppressPath getRoot() {
        return CloseSuppressPath.of(this.wrapper.getRoot());
    }

    @Override
    public CloseSuppressPath getFileName() {
        return CloseSuppressPath.of(this.wrapper.getFileName());
    }

    @Override
    public CloseSuppressPath getParent() {
        return CloseSuppressPath.of(this.wrapper.getParent());
    }

    @Override
    public int getNameCount() {
        return this.wrapper.getNameCount();
    }

    @Override
    public CloseSuppressPath getName(int index) {
        return CloseSuppressPath.of(this.wrapper.getName(index));
    }

    @Override
    public CloseSuppressPath subpath(int beginIndex, int endIndex) {
        return CloseSuppressPath.of(this.wrapper.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.wrapper.startsWith(CloseSuppressPath.extract(other));
    }

    @Override
    public boolean startsWith(String other) {
        return this.wrapper.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.wrapper.endsWith(CloseSuppressPath.extract(other));
    }

    @Override
    public boolean endsWith(String other) {
        return this.wrapper.endsWith(other);
    }

    @Override
    public CloseSuppressPath normalize() {
        return CloseSuppressPath.of(this.wrapper.normalize());
    }

    @Override
    public CloseSuppressPath resolve(Path other) {
        return CloseSuppressPath.of(this.wrapper.resolve(CloseSuppressPath.extract(other)));
    }

    @Override
    public CloseSuppressPath resolve(String other) {
        return CloseSuppressPath.of(this.wrapper.resolve(other));
    }

    @Override
    public CloseSuppressPath resolveSibling(Path other) {
        return CloseSuppressPath.of(this.wrapper.resolveSibling(CloseSuppressPath.extract(other)));
    }

    @Override
    public CloseSuppressPath resolveSibling(String other) {
        return CloseSuppressPath.of(this.wrapper.resolveSibling(other));
    }

    @Override
    public CloseSuppressPath relativize(Path other) {
        return CloseSuppressPath.of(this.wrapper.relativize(CloseSuppressPath.extract(other)));
    }

    @Override
    public URI toUri() {
        return this.wrapper.toUri();
    }

    @Override
    public CloseSuppressPath toAbsolutePath() {
        return CloseSuppressPath.of(this.wrapper.toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrapper.toRealPath(options);
    }

    @Override
    public File toFile() {
        return this.wrapper.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.wrapper.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.wrapper.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        return CloseSuppressPath.of(this.wrapper.iterator());
    }

    @Override
    public int compareTo(Path other) {
        return this.wrapper.compareTo(CloseSuppressPath.extract(other));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CloseSuppressPath) {
            return this.wrapper.equals(((CloseSuppressPath)other).getJavaPath());
        }
        return this.wrapper.equals(other);
    }

    @Override
    public int hashCode() {
        return this.wrapper.hashCode();
    }

    @Override
    public String toString() {
        return this.wrapper.toString();
    }

    @Override
    public void forEach(Consumer<? super Path> action) {
        this.wrapper.forEach(action);
    }

    @Override
    public Spliterator<Path> spliterator() {
        return this.wrapper.spliterator();
    }

    public InputStream openInputStream(int bufferSize, OpenOption ... options) throws IOException {
        return new BufferedInputStream(this.openInputStream(options), bufferSize);
    }

    public InputStream openInputStream(OpenOption ... options) throws IOException {
        return Files.newInputStream(this, options);
    }

    private OutputStream openOutputStream(OpenOption ... options) throws IOException {
        return Files.newOutputStream(this, options);
    }

    public OutputStream openOutputStream(int bufferSize, OpenOption ... options) throws IOException {
        return new BufferedOutputStream(this.openOutputStream(options), bufferSize);
    }

    public void closeWithDeleteRecurse() {
        this.isDir = true;
    }

    public void mkdirs() throws IOException {
        Files.createDirectories(this, new FileAttribute[0]);
    }

    public Path getJavaPath() {
        return this.wrapper;
    }

    @Override
    public void close() throws IOException {
        if (this.isDir) {
            IOUtil.deleteDirRecurse(this);
        } else {
            Files.deleteIfExists(this);
        }
    }
}

