/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.io;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.rdfhdt.hdt.util.io.IOUtil;

public class CloseMappedByteBuffer
implements Closeable {
    private static final AtomicLong ID_GEN = new AtomicLong();
    private static final Map<Long, Throwable> MAP_TEST_MAP = new HashMap<Long, Throwable>();
    private static boolean mapTest = false;
    private final long id = ID_GEN.incrementAndGet();
    private final ByteBuffer buffer;
    private final boolean duplicated;

    static void markMapTest() {
        mapTest = true;
        MAP_TEST_MAP.clear();
    }

    static void crashMapTest() {
        mapTest = false;
        if (!MAP_TEST_MAP.isEmpty()) {
            AssertionError re = new AssertionError((Object)(MAP_TEST_MAP.size() + " MAP(S) NOT CLOSED!"));
            MAP_TEST_MAP.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getKey)).map(Map.Entry::getValue).forEach(arg_0 -> re.addSuppressed(arg_0));
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseMappedByteBuffer(String filename, ByteBuffer buffer, boolean duplicated) {
        this.duplicated = duplicated;
        this.buffer = buffer;
        if (mapTest && !duplicated) {
            Map<Long, Throwable> map = MAP_TEST_MAP;
            synchronized (map) {
                MAP_TEST_MAP.put(this.id, new Throwable("MAP " + filename + "#" + this.id + "|" + buffer));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (mapTest && !this.duplicated) {
            Map<Long, Throwable> map = MAP_TEST_MAP;
            synchronized (map) {
                MAP_TEST_MAP.remove(this.id);
            }
        }
        IOUtil.cleanBuffer(this.buffer);
    }

    public boolean isLoaded() {
        return ((MappedByteBuffer)this.buffer).isLoaded();
    }

    public MappedByteBuffer load() {
        return ((MappedByteBuffer)this.buffer).load();
    }

    public MappedByteBuffer force() {
        assert (this.buffer instanceof MappedByteBuffer);
        return ((MappedByteBuffer)this.buffer).force();
    }

    public ByteBuffer position(int newPosition) {
        return this.buffer.position(newPosition);
    }

    public ByteBuffer limit(int newLimit) {
        return this.buffer.limit(newLimit);
    }

    public ByteBuffer mark() {
        return this.buffer.mark();
    }

    public ByteBuffer reset() {
        return this.buffer.reset();
    }

    public ByteBuffer clear() {
        return this.buffer.clear();
    }

    public ByteBuffer flip() {
        return this.buffer.flip();
    }

    public ByteBuffer rewind() {
        return this.buffer.rewind();
    }

    public ByteBuffer slice() {
        return this.buffer.slice();
    }

    public ByteBuffer duplicate() {
        return this.buffer.duplicate();
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    public byte get() {
        return this.buffer.get();
    }

    public ByteBuffer put(byte b) {
        return this.buffer.put(b);
    }

    public byte get(int index) {
        return this.buffer.get(index);
    }

    public ByteBuffer put(int index, byte b) {
        return this.buffer.put(index, b);
    }

    public ByteBuffer get(byte[] dst, int offset, int length) {
        return this.buffer.get(dst, offset, length);
    }

    public ByteBuffer get(byte[] dst) {
        return this.buffer.get(dst);
    }

    public ByteBuffer put(ByteBuffer src) {
        return this.buffer.put(src);
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        return this.buffer.put(src, offset, length);
    }

    public ByteBuffer put(byte[] src) {
        return this.buffer.put(src);
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public ByteBuffer compact() {
        return this.buffer.compact();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int compareTo(ByteBuffer that) {
        return this.buffer.compareTo(that);
    }

    public int mismatch(ByteBuffer that) {
        return this.buffer.mismatch(that);
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public ByteBuffer order(ByteOrder bo) {
        return this.buffer.order(bo);
    }

    public int alignmentOffset(int index, int unitSize) {
        return this.buffer.alignmentOffset(index, unitSize);
    }

    public ByteBuffer alignedSlice(int unitSize) {
        return this.buffer.alignedSlice(unitSize);
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public ByteBuffer putChar(char value) {
        return this.buffer.putChar(value);
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public ByteBuffer putChar(int index, char value) {
        return this.buffer.putChar(index, value);
    }

    public CharBuffer asCharBuffer() {
        return this.buffer.asCharBuffer();
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public ByteBuffer putShort(short value) {
        return this.buffer.putShort(value);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public ByteBuffer putShort(int index, short value) {
        return this.buffer.putShort(index, value);
    }

    public ShortBuffer asShortBuffer() {
        return this.buffer.asShortBuffer();
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public ByteBuffer putInt(int value) {
        return this.buffer.putInt(value);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public ByteBuffer putInt(int index, int value) {
        return this.buffer.putInt(index, value);
    }

    public IntBuffer asIntBuffer() {
        return this.buffer.asIntBuffer();
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public ByteBuffer putLong(long value) {
        return this.buffer.putLong(value);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public ByteBuffer putLong(int index, long value) {
        return this.buffer.putLong(index, value);
    }

    public LongBuffer asLongBuffer() {
        return this.buffer.asLongBuffer();
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public ByteBuffer putFloat(float value) {
        return this.buffer.putFloat(value);
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.buffer.putFloat(index, value);
    }

    public FloatBuffer asFloatBuffer() {
        return this.buffer.asFloatBuffer();
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public ByteBuffer putDouble(double value) {
        return this.buffer.putDouble(value);
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.buffer.putDouble(index, value);
    }

    public DoubleBuffer asDoubleBuffer() {
        return this.buffer.asDoubleBuffer();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int position() {
        return this.buffer.position();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public ByteBuffer getInternalBuffer() {
        return this.buffer;
    }
}

