/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.disk;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.disk.LargeLongArray;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.disk.LongArrayDisk;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SimpleSplitLongArray
implements LongArray,
Closeable {
    final LongArray array;
    private final int shift;
    private final long max;
    private final int indexMask;
    private final int numbits;
    private long size;

    private SimpleSplitLongArray(LongArray array, int numbits, long size) {
        this.size = size;
        this.array = array;
        int b = Long.bitCount(numbits);
        if (b != 1 || numbits < 1 || numbits > 64) {
            throw new IllegalArgumentException("numbits should be 2, 4, 8, ... 64");
        }
        this.shift = 6 - BitUtil.log2(numbits - 1);
        this.max = -1L >>> 64 - numbits;
        this.indexMask = (1 << this.shift) - 1;
        this.numbits = numbits;
    }

    public static SimpleSplitLongArray int8Array(long size) {
        return SimpleSplitLongArray.intXArray(size, 8);
    }

    public static SimpleSplitLongArray int16Array(long size) {
        return SimpleSplitLongArray.intXArray(size, 16);
    }

    public static SimpleSplitLongArray int32Array(long size) {
        return SimpleSplitLongArray.intXArray(size, 32);
    }

    public static SimpleSplitLongArray int64Array(long size) {
        return SimpleSplitLongArray.intXArray(size, 64);
    }

    public static SimpleSplitLongArray intXArray(long size, int x) {
        return new SimpleSplitLongArray(new LargeLongArray(IOUtil.createLargeArray(1L + size / (long)(64 / x))), x, size);
    }

    public static SimpleSplitLongArray int8ArrayDisk(Path location, long size) {
        return SimpleSplitLongArray.intXArrayDisk(location, size, 8);
    }

    public static SimpleSplitLongArray int16ArrayDisk(Path location, long size) {
        return SimpleSplitLongArray.intXArrayDisk(location, size, 16);
    }

    public static SimpleSplitLongArray int32ArrayDisk(Path location, long size) {
        return SimpleSplitLongArray.intXArrayDisk(location, size, 32);
    }

    public static SimpleSplitLongArray int64ArrayDisk(Path location, long size) {
        return SimpleSplitLongArray.intXArrayDisk(location, size, 64);
    }

    public static SimpleSplitLongArray intXArrayDisk(Path location, long size, int x) {
        return new SimpleSplitLongArray(new LongArrayDisk(location, 1L + size / (long)(64 / x)), x, size);
    }

    @Override
    public long get(long index) {
        long rindex = index >>> this.shift;
        int sindex = (int)(index & (long)this.indexMask) << 6 - this.shift;
        return this.max & this.array.get(rindex) >>> sindex;
    }

    @Override
    public void set(long index, long value) {
        long v;
        long rindex = index >>> this.shift;
        int sindex = (int)(index & (long)this.indexMask) << 6 - this.shift;
        long old = this.array.get(rindex);
        if (old != (v = old & (this.max << sindex ^ 0xFFFFFFFFFFFFFFFFL) | (this.max & value) << sindex)) {
            this.array.set(rindex, v);
        }
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public int sizeOf() {
        return 1 << 6 - this.shift;
    }

    @Override
    public void resize(long newSize) throws IOException {
        this.size = newSize;
        this.array.resize(newSize / (long)(64 / this.numbits));
    }

    @Override
    public void clear() {
        this.array.clear();
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeObject(this.array);
    }
}

