/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.disk;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.io.CloseMappedByteBuffer;
import org.rdfhdt.hdt.util.io.IOUtil;

public class LongArrayDisk
implements Closeable,
LongArray {
    private static final long MAPPING_SIZE = 0x40000000L;
    private FileChannel channel;
    private CloseMappedByteBuffer[] mappings;
    private long size;
    private final Path location;

    public LongArrayDisk(String location, long size) {
        this(location, size, true);
    }

    public LongArrayDisk(String location, long size, boolean overwrite) {
        this(Path.of(location, new String[0]), size, overwrite);
    }

    public LongArrayDisk(Path location, long size) {
        this(location, size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongArrayDisk(Path location, long size, boolean overwrite) {
        this.location = location;
        try {
            this.size = size;
            this.channel = FileChannel.open(location, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            long sizeBits = this.getSizeBits();
            int blocks = (int)Math.ceil((double)sizeBits / 1.073741824E9);
            this.mappings = new CloseMappedByteBuffer[blocks];
            for (int block = 0; block < blocks; ++block) {
                long sizeMapping = block + 1 == blocks && sizeBits % 0x40000000L != 0L ? Math.min(0x40000000L, sizeBits % 0x40000000L) : 0x40000000L;
                assert (this.mappings[block] == null);
                this.mappings[block] = IOUtil.mapChannel(location.toAbsolutePath().toString(), this.channel, FileChannel.MapMode.READ_WRITE, (long)block * 0x40000000L, sizeMapping);
            }
            if (overwrite) {
                this.clear();
            }
        }
        catch (IOException e) {
            try {
                try {
                    if (this.mappings != null) {
                        IOUtil.closeAll(this.mappings);
                    }
                }
                finally {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException("can't create LongArrayDisk!", e);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.mappings);
        this.channel.close();
        this.mappings = null;
        this.channel = null;
    }

    @Override
    public long get(long x) {
        long p = x * 8L;
        int block = (int)(p / 0x40000000L);
        int offset = (int)(p % 0x40000000L);
        return this.mappings[block].getLong(offset);
    }

    @Override
    public void set(long index, long value) {
        if (index >= this.size || index < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long p = index * 8L;
        int block = (int)(p / 0x40000000L);
        int offset = (int)(p % 0x40000000L);
        this.mappings[block].putLong(offset, value);
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public int sizeOf() {
        return 64;
    }

    public void set0(long startIndex, long endIndex) {
        long start = startIndex * 8L;
        long end = endIndex * 8L;
        if (start >= end) {
            return;
        }
        int startBlock = (int)(start / 0x40000000L);
        int endBlock = (int)((end - 1L) / 0x40000000L);
        byte[] zeros = new byte[4096];
        int c = 0;
        int lastBlock = startBlock;
        for (int i = startBlock; i <= endBlock; ++i) {
            CloseMappedByteBuffer mapping = this.mappings[i];
            int capacity = mapping.capacity();
            int startBuffer = i == startBlock ? (int)(start % 0x40000000L) : 0;
            int endBuffer = i == endBlock ? (end % 0x40000000L == 0L ? 0x40000000 : (int)(end % 0x40000000L)) : capacity;
            assert (endBuffer > startBuffer) : "start after end " + startBuffer + " -> " + endBuffer;
            int toWrite = endBuffer - startBuffer;
            int shift = 0;
            while (toWrite > 0) {
                mapping.position(startBuffer + shift);
                int w = Math.min(toWrite, zeros.length);
                mapping.put(zeros, 0, w);
                shift += w;
                toWrite -= w;
                if ((c += w) <= 10000000) continue;
                c = 0;
                for (int j = lastBlock; j < i; ++j) {
                    this.mappings[j].force();
                }
                lastBlock = i;
            }
        }
        for (int j = lastBlock; j <= endBlock; ++j) {
            this.mappings[j].force();
        }
    }

    @Override
    public void resize(long newSize) throws IOException {
        if (this.size == newSize) {
            return;
        }
        long oldSize = this.size;
        this.size = newSize;
        long sizeBit = this.getSizeBits();
        int blocks = (int)Math.ceil((double)sizeBit / 1.073741824E9);
        Closeable[] mappings = new CloseMappedByteBuffer[blocks];
        try {
            for (Closeable mapping : mappings) {
                if (mapping == null) continue;
                ((CloseMappedByteBuffer)mapping).force();
            }
            IOUtil.closeAll(this.mappings);
            this.mappings = null;
            this.channel.truncate(sizeBit);
            for (int block = 0; block < blocks; ++block) {
                long sizeMapping = block + 1 == blocks && sizeBit % 0x40000000L != 0L ? Math.min(0x40000000L, sizeBit % 0x40000000L) : 0x40000000L;
                mappings[block] = IOUtil.mapChannel(this.location.toAbsolutePath().toString(), this.channel, FileChannel.MapMode.READ_WRITE, (long)block * 0x40000000L, sizeMapping);
            }
            this.mappings = mappings;
            this.set0(oldSize, newSize);
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.closeAll(mappings);
                throw throwable;
            }
        }
    }

    @Override
    public void clear() {
        this.set0(0L, this.length());
    }

    public Path getLocation() {
        return this.location;
    }

    public long getSize() {
        return this.size;
    }

    public long getSizeBits() {
        return this.size * 8L;
    }
}

