/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.disk;

import java.io.IOException;
import org.rdfhdt.hdt.unsafe.UnsafeLongArray;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.io.IOUtil;

public class LargeLongArray
implements LongArray {
    private UnsafeLongArray array;

    public LargeLongArray(UnsafeLongArray array) {
        this.array = array;
    }

    @Override
    public long get(long index) {
        return this.array.get(index);
    }

    @Override
    public void set(long index, long value) {
        this.array.set(index, value);
    }

    @Override
    public long length() {
        return this.array.length();
    }

    @Override
    public int sizeOf() {
        return this.array.sizeOf();
    }

    @Override
    public void resize(long newSize) throws IOException {
        if (newSize > 0L && this.array.length() != newSize) {
            UnsafeLongArray a = IOUtil.createLargeArray(newSize, false);
            UnsafeLongArray.arraycopy(this.array, 0L, a, 0L, Math.min(newSize, this.array.length()));
            this.array = a;
        }
    }

    @Override
    public void clear() {
        this.array.clear();
    }
}

