/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import org.rdfhdt.hdt.listener.MultiThreadListener;

public class TreeWorker<S, T> {
    private static final AtomicInteger JOB_ID_NAME = new AtomicInteger();
    private final Object FETCH_SYNC = new Object(){};
    private final Object WAITING_SYNC = new Object(){};
    private final Object WORKING_SYNC = new Object(){};
    private final TreeWorkerCat<T> catFunction;
    private final TreeWorkerSupplier<S> baseLevelSupplier;
    private final TreeWorkerMap<S, T> mapFunction;
    private final TreeWorkerDelete<T> delete;
    private final IntFunction<T[]> arrayBuilder;
    private int maxLevel = 0;
    private int workerWaiting = 0;
    private int workerWorking;
    private final int treeCount;
    private final List<Element> elements = new ArrayList<Element>();
    private final List<S> suppliedElements = new ArrayList<S>();
    private final List<Worker> workers;
    private boolean started = false;
    private boolean fetchDone = false;
    private boolean mapDone = false;
    private TreeWorkerException throwable;
    private MultiThreadListener listener;

    public TreeWorker(TreeWorkerCat<T> catFunction, TreeWorkerSupplier<S> baseLevelSupplier, TreeWorkerDelete<T> delete, TreeWorkerMap<S, T> mapFunction, IntFunction<T[]> arrayBuilder) throws TreeWorkerException {
        this(catFunction, baseLevelSupplier, delete, mapFunction, arrayBuilder, Runtime.getRuntime().availableProcessors(), 1);
    }

    public <E extends TreeWorkerCat<T> & TreeWorkerSupplier<S> & TreeWorkerMap<S, T>> TreeWorker(E workerObject, IntFunction<T[]> arrayBuilder, int workers, int nodePerMerge) throws TreeWorkerException {
        this(workerObject, workerObject, (TreeWorkerDelete)workerObject, workerObject, arrayBuilder, workers, nodePerMerge);
    }

    public TreeWorker(TreeWorkerCat<T> catFunction, TreeWorkerSupplier<S> baseLevelSupplier, TreeWorkerDelete<T> delete, TreeWorkerMap<S, T> mapFunction, IntFunction<T[]> arrayBuilder, int workers, int nodePerMerge) throws TreeWorkerException {
        this.catFunction = Objects.requireNonNull(catFunction, "catFunction can't be null!");
        this.mapFunction = Objects.requireNonNull(mapFunction, "mapFunction can't be null!");
        this.baseLevelSupplier = Objects.requireNonNull(baseLevelSupplier, "baseLevelSupplier can't be null!");
        this.arrayBuilder = Objects.requireNonNull(arrayBuilder, "arrayBuilder can't be null!");
        this.delete = delete == null ? t -> {} : delete;
        if (nodePerMerge <= 0) {
            throw new TreeWorkerException("nodePerMerge count can't be <= 0!");
        }
        this.treeCount = 1 << nodePerMerge;
        if (workers <= 0) {
            throw new TreeWorkerException("worker count can't be <= 0!");
        }
        S s = baseLevelSupplier.get();
        if (s == null) {
            throw new TreeWorkerException("no base element!");
        }
        this.suppliedElements.add(s);
        this.workers = new ArrayList<Worker>(workers);
        for (int i = 0; i < workers; ++i) {
            this.workers.add(new Worker());
        }
        this.workerWorking = workers;
    }

    private T[] createArray(int size) {
        T[] array = this.arrayBuilder.apply(size);
        assert (array != null && array.length >= size) : "array function should create an array with a size of a least size";
        return array;
    }

    public void setListener(MultiThreadListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        List<Element> list = this.elements;
        synchronized (list) {
            if (this.started) {
                throw new IllegalArgumentException("TreeWorker already started!");
            }
            for (Worker worker : this.workers) {
                worker.start();
            }
            this.started = true;
        }
    }

    private void clearData() {
        for (Element e : this.elements) {
            this.delete.delete(e.mappedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitToComplete() throws TreeWorkerException, InterruptedException {
        try {
            if (this.listener != null) {
                Iterator<Worker> iterator = this.WORKING_SYNC;
                synchronized (iterator) {
                    while (this.workerWorking > 0) {
                        this.listener.notifyProgress(100.0f * (float)(this.workers.size() - this.workerWorking) / (float)this.workers.size(), "waiting for workers to complete " + (this.workers.size() - this.workerWorking) + "/" + this.workers.size());
                        this.WORKING_SYNC.wait();
                    }
                }
            }
            for (Worker w : this.workers) {
                w.join();
            }
            if (this.listener != null) {
                this.listener.notifyProgress(100.0f, "tree completed");
            }
        }
        catch (InterruptedException e) {
            this.clearData();
            throw e;
        }
        if (this.throwable != null) {
            this.clearData();
            throw this.throwable;
        }
        if (!this.fetchDone || !this.mapDone) {
            this.clearData();
            throw new TreeWorkerException("The worker isn't done!");
        }
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get((int)0).mappedValue;
    }

    private int countBase() {
        return this.suppliedElements.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        List<Element> list = this.elements;
        synchronized (list) {
            return this.fetchDone && this.mapDone && this.elements.size() <= 1 || this.throwable != null;
        }
    }

    public static class TreeWorkerException
    extends Exception {
        public TreeWorkerException(Throwable cause) {
            super(cause);
        }

        public TreeWorkerException(String message) {
            super(message);
        }
    }

    private class Worker
    extends Thread {
        private final Tuple tuple;

        public Worker() {
            super("JobWorker#" + JOB_ID_NAME.incrementAndGet());
            this.tuple = new Tuple();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            try {
                while (!TreeWorker.this.isCompleted()) {
                    if (TreeWorker.this.listener != null) {
                        TreeWorker.this.listener.notifyProgress(0.0f, "waiting job");
                    }
                    TreeWorkerJob job = null;
                    try {
                        Object object2 = TreeWorker.this.WAITING_SYNC;
                        // MONITORENTER : object2
                        job = this.getJob();
                        if (job == null) {
                            if (TreeWorker.this.isCompleted()) {
                                // MONITOREXIT : object2
                                return;
                            }
                            ++TreeWorker.this.workerWaiting;
                            TreeWorker.this.WAITING_SYNC.wait();
                            --TreeWorker.this.workerWaiting;
                            // MONITOREXIT : object2
                            continue;
                        }
                        // MONITOREXIT : object2
                        job.runJob();
                        object2 = TreeWorker.this.WAITING_SYNC;
                        // MONITORENTER : object2
                        if (TreeWorker.this.workerWaiting > 0) {
                            TreeWorker.this.WAITING_SYNC.notify();
                        }
                        // MONITOREXIT : object2
                    }
                    catch (Throwable t) {
                        if (job != null) {
                            job.clear();
                        }
                        object = TreeWorker.this.elements;
                        // MONITORENTER : object
                        if (TreeWorker.this.throwable != null) {
                            TreeWorker.this.throwable.addSuppressed(t);
                        }
                        TreeWorker.this.throwable = t instanceof TreeWorkerException ? (TreeWorkerException)t : new TreeWorkerException(t);
                        TreeWorker.this.elements.notifyAll();
                        // MONITOREXIT : object
                        object = TreeWorker.this.WAITING_SYNC;
                        // MONITORENTER : object
                        TreeWorker.this.WAITING_SYNC.notifyAll();
                        // MONITOREXIT : object
                    }
                }
                return;
            }
            finally {
                if (TreeWorker.this.listener != null) {
                    TreeWorker.this.listener.notifyProgress(100.0f, "completed");
                    TreeWorker.this.listener.unregisterThread(this.getName());
                }
                object = TreeWorker.this.WORKING_SYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TreeWorkerJob getJob() throws TreeWorkerException {
            List<Element> list = TreeWorker.this.elements;
            synchronized (list) {
                while (TreeWorker.this.mapDone) {
                    if (TreeWorker.this.elements.size() == 1) {
                        return null;
                    }
                    int level = this.tuple.searchDir(0, 1, 1);
                    if (level == -1) {
                        return null;
                    }
                    if (this.tuple.size() == 1) {
                        ++this.tuple.getFirstElement().level;
                        continue;
                    }
                    this.tuple.remove();
                    return new Merge(this.tuple.getArray(), this.tuple.size(), level);
                }
                if (TreeWorker.this.fetchDone) {
                    if (TreeWorker.this.suppliedElements.isEmpty()) {
                        return new Fetch();
                    }
                    return new Map(TreeWorker.this.suppliedElements.remove(0));
                }
                int level0 = TreeWorker.this.countBase();
                if (TreeWorker.this.workers.size() != 1 && level0 < TreeWorker.this.workers.size() / 2) {
                    return new Fetch();
                }
                int level = this.tuple.searchDir(TreeWorker.this.maxLevel, -1, TreeWorker.this.treeCount);
                if (level != -1) {
                    this.tuple.remove();
                    return new Merge(this.tuple.getArray(), this.tuple.size(), level);
                }
                if (TreeWorker.this.suppliedElements.isEmpty()) {
                    return new Fetch();
                }
                return new Map(TreeWorker.this.suppliedElements.remove(0));
            }
        }
    }

    private class Merge
    extends TreeWorkerJob {
        T[] elements;
        int count;
        int level;

        public Merge(T[] elements, int count, int level) {
            this.elements = elements;
            this.count = count;
            this.level = level;
            assert (count > 0) : "cat from empty element!";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Object t = TreeWorker.this.catFunction.construct(this.elements, this.count);
            List<Element> list = TreeWorker.this.elements;
            synchronized (list) {
                TreeWorker.this.elements.add(new Element(t, this.level + 1));
                TreeWorker.this.maxLevel = Math.max(TreeWorker.this.maxLevel, this.level + 1);
            }
        }

        @Override
        void clear() {
            for (int i = 0; i < this.count; ++i) {
                TreeWorker.this.delete.delete(this.elements[i]);
            }
        }
    }

    private class Map
    extends TreeWorkerJob {
        S old;

        public Map(S old) {
            this.old = old;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Object mappedValue = TreeWorker.this.mapFunction.map(this.old);
            List<Element> list = TreeWorker.this.elements;
            synchronized (list) {
                TreeWorker.this.elements.add(new Element(mappedValue, 0));
                if (TreeWorker.this.fetchDone && TreeWorker.this.suppliedElements.isEmpty()) {
                    TreeWorker.this.mapDone = true;
                }
                TreeWorker.this.elements.notifyAll();
            }
        }
    }

    private class Fetch
    extends TreeWorkerJob {
        private Fetch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            Object object = TreeWorker.this.FETCH_SYNC;
            synchronized (object) {
                if (TreeWorker.this.fetchDone) {
                    return;
                }
                Object s = TreeWorker.this.baseLevelSupplier.get();
                List<Element> list = TreeWorker.this.elements;
                synchronized (list) {
                    if (s == null) {
                        TreeWorker.this.fetchDone = true;
                        if (TreeWorker.this.suppliedElements.isEmpty()) {
                            TreeWorker.this.mapDone = true;
                        }
                    } else {
                        TreeWorker.this.suppliedElements.add(s);
                    }
                    TreeWorker.this.elements.notifyAll();
                }
            }
        }
    }

    private static abstract class TreeWorkerJob {
        private TreeWorkerJob() {
        }

        abstract void runJob();

        void clear() {
        }
    }

    private class Tuple {
        Element first;
        T[] elements;
        int count;
        int level;

        Tuple() {
            this.elements = TreeWorker.this.createArray(TreeWorker.this.treeCount);
            this.clear();
        }

        public void addElement(Element e) {
            if (this.count == 0) {
                this.first = e;
                this.level = e.level;
            }
            this.elements[this.count++] = e.mappedValue;
            assert (this.level == e.level) : "add from different level";
        }

        public Element getFirstElement() {
            return this.first;
        }

        public void remove() throws TreeWorkerException {
            for (int i = 0; i < this.count; ++i) {
                this.removeFirst(this.elements[i]);
            }
        }

        private void removeFirst(T element) throws TreeWorkerException {
            Iterator<Element> it = TreeWorker.this.elements.iterator();
            while (it.hasNext()) {
                Element e = it.next();
                if (e.mappedValue != element || e.level != this.level) continue;
                it.remove();
                return;
            }
            throw new TreeWorkerException("Can't remove an elements! " + element);
        }

        public T[] getArray() {
            return this.elements;
        }

        public int size() {
            return this.count;
        }

        public void clear() {
            this.count = 0;
        }

        public T get(int index) {
            return this.elements[index];
        }

        private int searchDir(int start, int direction, int min) {
            if (direction < 0) {
                for (int i = start; i >= 0; --i) {
                    this.searchAtLevel(i);
                    if (this.size() < min) continue;
                    return i;
                }
            } else {
                for (int i = start; i <= TreeWorker.this.maxLevel; ++i) {
                    this.searchAtLevel(i);
                    if (this.size() < min) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchAtLevel(int level) {
            this.clear();
            List<Element> list = TreeWorker.this.elements;
            synchronized (list) {
                for (Element e : TreeWorker.this.elements) {
                    if (e.level != level) continue;
                    this.addElement(e);
                    if (this.count != TreeWorker.this.treeCount) continue;
                    return;
                }
            }
        }
    }

    private class Element {
        T mappedValue;
        int level;

        public Element(T mappedValue, int level) {
            this.mappedValue = mappedValue;
            this.level = level;
        }
    }

    public static interface TreeWorkerObjectNoMap<T>
    extends TreeWorkerObject<T, T> {
        @Override
        default public T map(T prev) {
            return prev;
        }
    }

    public static interface TreeWorkerObject<S, T>
    extends TreeWorkerCat<T>,
    TreeWorkerSupplier<S>,
    TreeWorkerDelete<T>,
    TreeWorkerMap<S, T> {
    }

    @FunctionalInterface
    public static interface TreeWorkerSupplier<S> {
        public S get();
    }

    @FunctionalInterface
    public static interface TreeWorkerDelete<T> {
        public void delete(T var1);
    }

    @FunctionalInterface
    public static interface TreeWorkerCat<T> {
        public T construct(T[] var1, int var2);
    }

    public static interface TreeWorkerMap<T, E> {
        public static <T> TreeWorkerMap<T, T> identity() {
            return t -> t;
        }

        public E map(T var1);
    }
}

