/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util.concurrent;

import java.util.Objects;

public class ExceptionThread
extends Thread {
    private Throwable exception = null;
    private final ExceptionRunnable target;
    private ExceptionThread next;
    private ExceptionThread prev;

    public static ExceptionThread async(String name, ExceptionRunnable ... runnables) {
        Objects.requireNonNull(name, "name can't be null!");
        Objects.requireNonNull(runnables, "runnables can't be null");
        for (int i = 0; i < runnables.length; ++i) {
            Objects.requireNonNull(runnables[i], "runnable#" + i + " is null!");
        }
        if (runnables.length == 0) {
            throw new IllegalArgumentException("empty runnable list");
        }
        ExceptionThread thread = new ExceptionThread(runnables[0], name + "#0");
        for (int i = 1; i < runnables.length; ++i) {
            thread.attach(new ExceptionThread(runnables[i], name + "#" + i));
        }
        return thread;
    }

    public ExceptionThread(String name) {
        this((ExceptionRunnable)null, name);
    }

    public ExceptionThread(ExceptionRunnable target, String name) {
        super(name);
        this.target = Objects.requireNonNullElse(target, this::runException);
    }

    public ExceptionThread attach(ExceptionThread ... threads) {
        Objects.requireNonNull(threads, "can't attach null thread");
        for (ExceptionThread thread : threads) {
            if (thread.prev != null) {
                throw new IllegalArgumentException("Thread " + thread.getName() + " already attached");
            }
            if (this.next != null) {
                this.next.attach(thread);
                continue;
            }
            this.next = thread;
            thread.prev = this;
        }
        return this;
    }

    public ExceptionThread startAll() {
        ExceptionThread prev = this.prev;
        while (prev != null) {
            prev.start();
            prev = prev.prev;
        }
        this.start();
        ExceptionThread next = this.next;
        while (next != null) {
            next.start();
            next = next.next;
        }
        return this;
    }

    public void runException() throws Exception {
    }

    @Override
    public final void run() {
        block4: {
            try {
                this.target.run();
            }
            catch (Throwable t) {
                if (this.exception != null) {
                    this.exception.addSuppressed(t);
                    return;
                }
                this.exception = t;
                if (this.next != null) {
                    this.next.interruptForward(t);
                }
                if (this.prev == null) break block4;
                this.prev.interruptBackward(t);
            }
        }
    }

    private void interruptBackward(Throwable t) {
        this.exception = t;
        if (this.prev != null) {
            this.prev.interruptBackward(t);
        }
        this.interrupt();
    }

    private void interruptForward(Throwable t) {
        this.exception = t;
        if (this.next != null) {
            this.next.interruptForward(t);
        }
        this.interrupt();
    }

    public Throwable getException() {
        return this.exception;
    }

    public void joinAndCrashIfRequired() throws InterruptedException {
        try {
            this.join();
            ExceptionThread next = this.next;
            while (next != null) {
                next.join();
                next = next.next;
            }
            ExceptionThread prev = this.prev;
            while (prev != null) {
                prev.join();
                prev = prev.prev;
            }
        }
        catch (InterruptedException ie) {
            if (this.exception != null) {
                ie.addSuppressed(this.exception);
            }
            throw ie;
        }
        if (this.exception == null) {
            return;
        }
        if (this.exception instanceof ExceptionThreadException) {
            throw (ExceptionThreadException)this.exception;
        }
        throw new ExceptionThreadException(this.exception);
    }

    public static class ExceptionThreadException
    extends RuntimeException {
        public ExceptionThreadException(Throwable cause) {
            super(cause);
        }
    }

    @FunctionalInterface
    public static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

