/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.rdfhdt.hdt.exceptions.NotImplementedException;

public class ParallelSortableArrayList<T>
implements List<T> {
    public static final double GROW_FACTOR = 1.5;
    private int used;
    private T[] array;
    private final Class<T[]> type;

    public ParallelSortableArrayList(Class<T[]> type) {
        this(type, 16);
    }

    public ParallelSortableArrayList(Class<T[]> type, int capacity) {
        this.type = type;
        this.array = (Object[])Array.newInstance(type.getComponentType(), capacity);
    }

    private void checkSize(int newSize) {
        if (newSize >= this.array.length) {
            int allocate = (int)Math.min(0x7FFFFFFAL, (long)((double)newSize * 1.5));
            this.array = Arrays.copyOf(this.array, allocate, this.type);
        }
    }

    @Override
    public boolean add(T element) {
        this.checkSize(this.used + 1);
        this.array[this.used++] = element;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.used; ++i) {
            this.array[i] = null;
        }
        this.used = 0;
    }

    @Override
    public T get(int index) {
        return this.array[index];
    }

    @Override
    public T set(int index, T element) {
        this.array[index] = element;
        return this.array[index];
    }

    @Override
    public void add(int index, T element) {
        throw new NotImplementedException();
    }

    @Override
    public T remove(int index) {
        throw new NotImplementedException();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new NotImplementedException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException();
    }

    public T[] getArray() {
        return this.array;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.array).subList(0, this.used).iterator();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.used, Object[].class);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new NotImplementedException();
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        Arrays.sort(this.array, 0, this.used, comparator);
    }

    public void parallelSort(Comparator<T> comparator) {
        Arrays.parallelSort(this.array, 0, this.used, comparator);
    }
}

