/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.util.ConcurrentModificationException;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.util.string.ReplazableString;

public class LiteralsUtils {
    public static final byte DATATYPE_BYTE = 33;
    public static final String NO_DATATYPE_STR = "NO_DATATYPE";
    public static final ByteString TYPE_OPERATOR = ByteString.of("^^");
    static final String LITERAL_LANG_TYPE_STR = "<http://www.w3.org/1999/02/22-rdf-syntax-ns#langString>";
    public static final ByteString NO_DATATYPE = new CompactString("NO_DATATYPE");
    public static final ByteString LITERAL_LANG_TYPE = new CompactString("<http://www.w3.org/1999/02/22-rdf-syntax-ns#langString>");

    public static boolean containsLanguage(CharSequence str) {
        if (str.length() == 0 || str.charAt(0) != '\"') {
            return false;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-') continue;
            if (c == '\"') {
                return false;
            }
            return c == '@';
        }
        throw new ConcurrentModificationException("Update of the char sequence while reading!");
    }

    private static int getTypeIndex(CharSequence str) {
        int i;
        if (str.length() == 0 || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '>') {
            return -1;
        }
        for (i = str.length() - 1; i > 0 && (str.charAt(i) != '<' || str.charAt(i - 1) == '\\'); --i) {
        }
        char c = str.charAt(i - 1);
        if (c == '\"' || c == '@') {
            return -1;
        }
        if (c == '^') {
            return i;
        }
        throw new ConcurrentModificationException("Update of the char sequence while reading!");
    }

    public static CharSequence getType(CharSequence str) {
        if (LiteralsUtils.containsLanguage(str)) {
            return LITERAL_LANG_TYPE;
        }
        int index = LiteralsUtils.getTypeIndex(str);
        if (index != -1 && index < str.length()) {
            return str.subSequence(index, str.length());
        }
        return NO_DATATYPE;
    }

    public static CharSequence removeType(CharSequence str) {
        int index = LiteralsUtils.getTypeIndex(str);
        if (index != -1 && index < str.length()) {
            return str.subSequence(0, index - 2);
        }
        return str;
    }

    static boolean isLangType(CharSequence s, int start) {
        if (start + LITERAL_LANG_TYPE_STR.length() > s.length()) {
            return false;
        }
        for (int i = 0; i < LITERAL_LANG_TYPE_STR.length(); ++i) {
            if (s.charAt(i + start) == LITERAL_LANG_TYPE_STR.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static CharSequence litToPref(CharSequence str) {
        if (LiteralsUtils.containsLanguage(str)) {
            ReplazableString prefixedValue = new ReplazableString(1 + LITERAL_LANG_TYPE.length() + str.length());
            prefixedValue.append(new byte[]{33}, 0, 1);
            prefixedValue.append(LITERAL_LANG_TYPE.getBuffer(), 0, LITERAL_LANG_TYPE.length());
            prefixedValue.appendNoCompact(str);
            return prefixedValue;
        }
        int index = LiteralsUtils.getTypeIndex(str);
        if (index != -1 && index < str.length()) {
            ReplazableString prefixedValue = new ReplazableString(str.length() - 1);
            prefixedValue.append(new byte[]{33}, 0, 1);
            prefixedValue.appendNoCompact(str, index, str.length() - index);
            prefixedValue.appendNoCompact(str, 0, index - 2);
            return prefixedValue;
        }
        return str;
    }

    public static CharSequence removePrefType(CharSequence str) {
        char c;
        int index;
        if (str.length() < 4 || str.charAt(0) != '^' || str.charAt(1) != '^') {
            return str;
        }
        assert (str.charAt(2) == '<') : "non typed literal prefix";
        for (index = 3; index < str.length() && (c = str.charAt(index)) != '>'; ++index) {
        }
        assert (index < str.length() - 1 && str.charAt(index + 1) == '\"') : "badly typed literal prefix";
        return str.subSequence(index + 1, str.length());
    }

    public static CharSequence prefToLit(CharSequence str) {
        char c;
        if (str.length() < 1 || str.charAt(0) != '!') {
            return str;
        }
        int index = 2;
        if (LiteralsUtils.isLangType(str, index - 1)) {
            return str.subSequence(LITERAL_LANG_TYPE.length() + 1, str.length());
        }
        while (index < str.length() && (c = str.charAt(index)) != '>') {
            ++index;
        }
        assert (index < str.length() - 1 && str.charAt(index + 1) == '\"') : "badly typed literal prefix";
        ReplazableString bld = new ReplazableString(str.length() + 1);
        bld.appendNoCompact(str, index + 1, str.length() - index - 1);
        bld.appendNoCompact(TYPE_OPERATOR);
        bld.appendNoCompact(str, 1, index);
        return bld;
    }

    public static ByteString embed(ByteString s1) {
        if (s1 == null || s1.length() == 0) {
            return EmbeddedURI.EMPTY;
        }
        if (s1.charAt(0) == '<' && s1.charAt(s1.length() - 1) == '>') {
            return s1;
        }
        return new EmbeddedURI(s1);
    }

    public static boolean isNoDatatype(CharSequence seq) {
        if (seq.length() != NO_DATATYPE.length()) {
            return false;
        }
        for (int i = 0; i < NO_DATATYPE.length(); ++i) {
            if (NO_DATATYPE.charAt(i) == seq.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static class EmbeddedURI
    implements ByteString {
        private static final ByteString START = new CompactString("<");
        private static final ByteString END = new CompactString(">");
        private static final ByteString EMPTY = new CompactString("<>");
        private int hash;
        private final ByteString parent;

        public EmbeddedURI(ByteString parent) {
            this.parent = parent;
        }

        @Override
        public int length() {
            return this.parent.length() + 2;
        }

        @Override
        public char charAt(int index) {
            if (index == 0) {
                return '<';
            }
            if (index == this.parent.length() + 1) {
                return '>';
            }
            return this.parent.charAt(index - 1);
        }

        @Override
        public byte[] getBuffer() {
            byte[] buffer = new byte[START.length() + this.parent.length() + END.length()];
            System.arraycopy(START.getBuffer(), 0, buffer, 0, START.length());
            System.arraycopy(this.parent.getBuffer(), 0, buffer, START.length(), this.parent.length());
            System.arraycopy(END.getBuffer(), 0, buffer, START.length() + this.parent.length(), END.length());
            return buffer;
        }

        @Override
        public ByteString subSequence(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            if (start == 0) {
                return START.copyAppend(this.parent.subSequence(0, end - 1));
            }
            if (end == this.length()) {
                return this.parent.subSequence(start - 1, this.parent.length()).copyAppend(END);
            }
            return this.parent.subSequence(start - 1, end - 1);
        }

        @Override
        public String toString() {
            return "<" + this.parent + ">";
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof CharSequence)) {
                return false;
            }
            return CharSequenceComparator.getInstance().compare(this, (CharSequence)o) == 0;
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = -2128831035;
                int i = this.length();
                while (i-- != 0) {
                    this.hash = this.hash * 16777619 ^ this.charAt(i);
                }
            }
            return this.hash;
        }
    }
}

