/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitUtil {
    private BitUtil() {
    }

    public static int log2(long n) {
        return n != 0L ? 64 - Long.numberOfLeadingZeros(n) : 0;
    }

    public static long maxVal(int numbits) {
        return numbits == 64 ? Long.MAX_VALUE : -1L << numbits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long readLowerBitsByteAligned(long numbits, InputStream in) throws IOException {
        int bitsRead = 0;
        long value = 0L;
        while ((long)bitsRead < numbits) {
            long readByte = in.read();
            if (readByte == -1L) {
                throw new EOFException();
            }
            value |= readByte << bitsRead;
            bitsRead += 8;
        }
        return value;
    }

    public static void writeLowerBitsByteAligned(long value, long numbits, OutputStream out) throws IOException {
        while (numbits > 0L) {
            out.write((int)(value & 0xFFL));
            value >>>= 8;
            numbits -= 8L;
        }
    }

    public static int select1(long value, int rank) {
        int bitpos = 0;
        while (rank > 0 && value != 0L) {
            rank = (int)((long)rank - (value & 1L));
            ++bitpos;
            value >>>= 1;
        }
        return bitpos;
    }

    public static int select0(long value, int rank) {
        int bitpos = 0;
        while (rank > 0) {
            rank = (int)((long)rank - ((value ^ 1L) & 1L));
            ++bitpos;
            value >>>= 1;
        }
        return bitpos;
    }
}

