/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.unsafe;

import java.util.Arrays;
import java.util.Objects;
import org.rdfhdt.hdt.unsafe.MemoryUtils;

public class UnsafeLongArray {
    private static final int SIZE_OF = 8;
    private final long pointer;
    private final long[] javaArray;
    private final long size;

    public static void arraycopy(UnsafeLongArray src, long srcPos, UnsafeLongArray dest, long destPos, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length");
        }
        if (length == 0L || src == dest) {
            return;
        }
        if (srcPos < 0L || srcPos + length > src.size()) {
            throw new IllegalArgumentException("source block out of bound!");
        }
        if (destPos < 0L || destPos + length > dest.size()) {
            throw new IllegalArgumentException("destination block out of bound!");
        }
        if (src.isUsingUnsafe() && dest.isUsingUnsafe()) {
            MemoryUtils.memcpy(dest.pointer + destPos * (long)dest.sizeOf(), src.pointer + srcPos * (long)src.sizeOf(), length);
        } else if (!src.isUsingUnsafe() && !dest.isUsingUnsafe()) {
            System.arraycopy(src.javaArray, (int)srcPos, dest.javaArray, (int)destPos, (int)length);
        } else {
            for (long i = 0L; i < length; ++i) {
                dest.set(destPos + i, src.get(srcPos + i));
            }
        }
    }

    public static UnsafeLongArray wrapper(long[] array) {
        return new UnsafeLongArray(array, false);
    }

    public static UnsafeLongArray allocate(long[] array) {
        return new UnsafeLongArray(array, true);
    }

    public static UnsafeLongArray allocate(long size) {
        return new UnsafeLongArray(size);
    }

    public static UnsafeLongArray allocate(long size, boolean initArray) {
        return new UnsafeLongArray(size, initArray);
    }

    private UnsafeLongArray(long[] javaArray, boolean copyArray) {
        this.size = javaArray.length;
        if (!copyArray) {
            this.pointer = 0L;
            this.javaArray = Objects.requireNonNull(javaArray, "javaArray can't be null!");
        } else if (this.size >= (long)MemoryUtils.getMaxArraySize()) {
            this.pointer = MemoryUtils.malloc(this.size, 8);
            MemoryUtils.bindPointerTo(this.pointer, this);
            this.javaArray = null;
            UnsafeLongArray.arraycopy(UnsafeLongArray.wrapper(javaArray), 0L, this, 0L, this.size);
        } else {
            this.javaArray = new long[(int)this.size];
            System.arraycopy(javaArray, 0, this.javaArray, 0, javaArray.length);
            this.pointer = 0L;
        }
    }

    private UnsafeLongArray(long size) {
        this(size, true);
    }

    private UnsafeLongArray(long size, boolean init) {
        this.size = size;
        if (size >= (long)MemoryUtils.getMaxArraySize()) {
            this.pointer = MemoryUtils.malloc(size, 8);
            MemoryUtils.bindPointerTo(this.pointer, this);
            this.javaArray = null;
            if (init) {
                this.clear();
            }
        } else {
            this.javaArray = new long[(int)size];
            this.pointer = 0L;
        }
    }

    public void clear() {
        if (this.javaArray == null) {
            MemoryUtils.memset(this.pointer, this.size * (long)this.sizeOf(), (byte)0);
        } else {
            Arrays.fill(this.javaArray, 0L);
        }
    }

    public long get(long index) {
        if (this.javaArray != null) {
            return this.javaArray[(int)index];
        }
        assert (index >= 0L && index < this.size);
        return MemoryUtils.getUnsafe().getLong(this.pointer + index * 8L);
    }

    public void set(long index, long value) {
        if (this.javaArray != null) {
            this.javaArray[(int)index] = value;
            return;
        }
        assert (index >= 0L && index < this.size);
        MemoryUtils.getUnsafe().putLong(this.pointer + index * 8L, value);
    }

    public boolean isUsingUnsafe() {
        return this.javaArray == null;
    }

    public long size() {
        return this.size;
    }

    public long length() {
        return this.size;
    }

    public int sizeOf() {
        return 8;
    }
}

