/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.unsafe;

import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import java.util.stream.IntStream;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import sun.misc.Unsafe;

public class MemoryUtils {
    private static final Unsafe UNSAFE;
    private static final Cleaner CLEANER;
    private static final long ZERO_BUFFER;
    private static final long MINUS_ONE_BUFFER;
    private static final Object BUFFER_PARENT;
    private static final int BUFFER_SIZE_BITS = 12;
    private static final int BUFFER_SIZE;
    static int maxArraySize;
    static long thresholdParallelSizeSet;

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static Cleaner getCleaner() {
        return CLEANER;
    }

    public static int getMaxArraySize() {
        return maxArraySize;
    }

    public static long malloc(long size, int sizeOf) {
        return MemoryUtils.malloc(size * (long)sizeOf);
    }

    public static long malloc(long size) {
        return UNSAFE.allocateMemory(size);
    }

    public static void free(long ptr) {
        UNSAFE.freeMemory(ptr);
    }

    public static void bindPointerTo(long pointer, Object parent) {
        CLEANER.register(parent, new CleanerObject(pointer));
    }

    private static void memorySet0(long ptr, long size, byte value) {
        long addr;
        if (value == -1) {
            MemoryUtils.memorySetBuffer(ptr, size, MINUS_ONE_BUFFER);
            return;
        }
        if (value == 0) {
            MemoryUtils.memorySetBuffer(ptr, size, ZERO_BUFFER);
            return;
        }
        int uv = value & 0xFF;
        long lvalue = (long)(uv | uv << 8 | uv << 16) | (long)uv << 24 | (long)uv << 32 | (long)uv << 40 | (long)uv << 48 | (long)uv << 56;
        long lend = ptr + (size & 0xFFFFFFFFFFFFFFF8L) - 1L;
        for (addr = ptr; addr < lend; addr += 8L) {
            UNSAFE.putLong(addr, lvalue);
        }
        while (addr < ptr + size) {
            UNSAFE.putByte(addr, value);
            ++addr;
        }
    }

    private static void memorySetBuffer(long ptr, long size, long buffer) {
        long addr = ptr;
        long tow = size;
        while (tow > 0L) {
            long len = tow > (long)BUFFER_SIZE ? (long)BUFFER_SIZE : tow;
            UNSAFE.copyMemory(buffer, addr, len);
            tow -= len;
            addr += len;
        }
    }

    public static void memcpy(long dst, long src, long size) {
        UNSAFE.copyMemory(src, dst, size);
    }

    public static void memset(long ptr, long size, byte value) {
        if (size > thresholdParallelSizeSet) {
            int processors = Runtime.getRuntime().availableProcessors();
            long blockSize = size / (long)processors + 1L;
            try {
                ExceptionThread.async("memorySetThread", (ExceptionThread.ExceptionRunnable[])IntStream.range(0, processors).mapToObj(processor -> {
                    long start = blockSize * (long)processor;
                    long end = Math.min(size, blockSize * (long)(processor + 1));
                    return () -> MemoryUtils.memorySet0(ptr + start, end - start, value);
                }).toArray(ExceptionThread.ExceptionRunnable[]::new)).startAll().joinAndCrashIfRequired();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            MemoryUtils.memorySet0(ptr, size, value);
        }
    }

    private MemoryUtils() {
        throw new IllegalArgumentException("Can't init utils class");
    }

    static {
        CLEANER = Cleaner.create();
        BUFFER_PARENT = new Object(){};
        maxArraySize = 0x3FFFFFFF;
        thresholdParallelSizeSet = (long)maxArraySize * 10L;
        try {
            Field f = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
            if (UNSAFE == null) {
                throw new NullPointerException("Unsafe value is null!");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException | SecurityException e) {
            throw new Error("Can't get field value sun.misc.Unsafe", e);
        }
        BUFFER_SIZE = 4096;
        ZERO_BUFFER = UNSAFE.allocateMemory(BUFFER_SIZE);
        MemoryUtils.bindPointerTo(ZERO_BUFFER, BUFFER_PARENT);
        MINUS_ONE_BUFFER = UNSAFE.allocateMemory(BUFFER_SIZE);
        MemoryUtils.bindPointerTo(MINUS_ONE_BUFFER, BUFFER_PARENT);
        for (long i = 0L; i < (long)(BUFFER_SIZE >> 3); ++i) {
            UNSAFE.putLong(ZERO_BUFFER + i * 8L, 0L);
            UNSAFE.putLong(MINUS_ONE_BUFFER + i * 8L, -1L);
        }
    }

    private static class CleanerObject
    implements Runnable {
        private long ptr;

        private CleanerObject(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            if (this.ptr != 0L) {
                MemoryUtils.free(this.ptr);
                this.ptr = 0L;
            }
        }
    }
}

