/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.AppendableWriteBitmap;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.iterator.SuppliableIteratorTripleID;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class WriteBitmapTriples
implements TriplesPrivate {
    protected TripleComponentOrder order;
    private long numTriples;
    private final AppendableWriteBitmap bitY;
    private final AppendableWriteBitmap bitZ;
    private final CloseSuppressPath seqY;
    private final CloseSuppressPath seqZ;
    private final CloseSuppressPath triples;
    private SequenceLog64BigDisk vectorY;
    private SequenceLog64BigDisk vectorZ;

    public WriteBitmapTriples(HDTOptions spec, CloseSuppressPath triples, int bufferSize) throws IOException {
        String orderStr = spec.get("triplesOrder");
        this.order = orderStr == null ? TripleComponentOrder.SPO : TripleComponentOrder.valueOf((String)orderStr);
        triples.mkdirs();
        triples.closeWithDeleteRecurse();
        this.triples = triples;
        this.bitY = new AppendableWriteBitmap(triples.resolve("bitmapY"), bufferSize);
        this.bitZ = new AppendableWriteBitmap(triples.resolve("bitmapZ"), bufferSize);
        this.seqY = triples.resolve("seqY");
        this.seqZ = triples.resolve("seqZ");
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.clear();
        ci.setFormat(this.getType());
        ci.setInt("order", (long)this.order.ordinal());
        ci.setType(ControlInfo.Type.TRIPLES);
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitY.save(output, iListener);
        this.bitZ.save(output, iListener);
        this.vectorY.save(output, iListener);
        this.vectorZ.save(output, iListener);
    }

    public IteratorTripleID searchAll() {
        throw new NotImplementedException();
    }

    @Override
    public SuppliableIteratorTripleID search(TripleID pattern) {
        throw new NotImplementedException();
    }

    public long getNumberOfElements() {
        return this.numTriples;
    }

    public long size() {
        return this.numTriples * 4L;
    }

    public void populateHeader(Header header, String rootNode) {
        if (rootNode == null || rootNode.length() == 0) {
            throw new IllegalArgumentException("Root node for the header cannot be null");
        }
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesnumTriples>", this.getNumberOfElements());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesOrder>", (CharSequence)this.order.toString());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#triplesBitmap>";
    }

    public TripleID findTriple(long position) {
        throw new NotImplementedException();
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void generateIndex(ProgressListener listener, HDTOptions disk, Dictionary dictionary) {
        throw new NotImplementedException();
    }

    @Override
    public void loadIndex(InputStream input, ControlInfo ci, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ControlInfo ci, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void saveIndex(OutputStream output, ControlInfo ci, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void load(TempTriples triples, ProgressListener listener) {
        triples.setOrder(this.order);
        triples.sort(listener);
        IteratorTripleID it = triples.searchAll();
        long number = it.estimatedNumResults();
        this.vectorY = new SequenceLog64BigDisk(this.seqY.toAbsolutePath().toString(), BitUtil.log2(number));
        this.vectorZ = new SequenceLog64BigDisk(this.seqZ.toAbsolutePath().toString(), BitUtil.log2(number));
        long lastX = 0L;
        long lastY = 0L;
        long lastZ = 0L;
        this.numTriples = 0L;
        while (it.hasNext()) {
            TripleID triple = (TripleID)it.next();
            TripleOrderConvert.swapComponentOrder(triple, TripleComponentOrder.SPO, this.order);
            long x = triple.getSubject();
            long y = triple.getPredicate();
            long z = triple.getObject();
            if (x == 0L || y == 0L || z == 0L) {
                throw new IllegalFormatException("None of the components of a triple can be null");
            }
            if (this.numTriples == 0L) {
                this.vectorY.append(y);
                this.vectorZ.append(z);
            } else if (x != lastX) {
                if (x != lastX + 1L) {
                    throw new IllegalFormatException("Upper level must be increasing and correlative.");
                }
                this.bitY.append(true);
                this.vectorY.append(y);
                this.bitZ.append(true);
                this.vectorZ.append(z);
            } else if (y != lastY) {
                if (y < lastY) {
                    throw new IllegalFormatException("Middle level must be increasing for each parent.");
                }
                this.bitY.append(false);
                this.vectorY.append(y);
                this.bitZ.append(true);
                this.vectorZ.append(z);
            } else {
                if (z < lastZ) {
                    throw new IllegalFormatException("Lower level must be increasing for each parent.");
                }
                this.bitZ.append(false);
                this.vectorZ.append(z);
            }
            lastX = x;
            lastY = y;
            lastZ = z;
            ListenerUtil.notifyCond(listener, "Converting to BitmapTriples", this.numTriples, this.numTriples, number);
            ++this.numTriples;
        }
        if (this.numTriples > 0L) {
            this.bitY.append(true);
            this.bitZ.append(true);
        }
        this.vectorY.aggressiveTrimToSize();
        this.vectorZ.aggressiveTrimToSize();
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.order;
    }

    public void close() throws IOException {
        IOUtil.closeAll(this.bitY, this.bitZ, this.vectorY, this.seqY, this.vectorZ, this.seqZ, this.triples);
    }
}

