/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import org.rdfhdt.hdt.triples.TripleID;

public final class TripleIDInt
implements Comparable<TripleIDInt> {
    private int subject;
    private int predicate;
    private int object;

    public TripleIDInt() {
    }

    public TripleIDInt(int subject, int predicate, int object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public TripleIDInt(long subject, long predicate, long object) {
        this.subject = (int)subject;
        this.predicate = (int)predicate;
        this.object = (int)object;
    }

    public TripleIDInt(TripleIDInt other) {
        this.subject = other.subject;
        this.predicate = other.predicate;
        this.object = other.object;
    }

    public TripleIDInt(TripleID other) {
        this.subject = (int)other.getSubject();
        this.predicate = (int)other.getPredicate();
        this.object = (int)other.getObject();
    }

    public int getSubject() {
        return this.subject;
    }

    public void setSubject(int subject) {
        this.subject = subject;
    }

    public int getObject() {
        return this.object;
    }

    public void setObject(int object) {
        this.object = object;
    }

    public int getPredicate() {
        return this.predicate;
    }

    public void setPredicate(int predicate) {
        this.predicate = predicate;
    }

    public void setAll(int subject, int predicate, int object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public void assign(TripleIDInt replacement) {
        this.subject = replacement.getSubject();
        this.object = replacement.getObject();
        this.predicate = replacement.getPredicate();
    }

    public void clear() {
        this.object = 0;
        this.predicate = 0;
        this.subject = 0;
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object;
    }

    public boolean equals(TripleIDInt other) {
        return this.subject == other.subject && this.predicate == other.predicate && this.object == other.object;
    }

    @Override
    public int compareTo(TripleIDInt other) {
        int result = this.subject - other.subject;
        if (result == 0) {
            result = this.predicate - other.predicate;
            if (result == 0) {
                return this.object - other.object;
            }
            return result;
        }
        return result;
    }

    public boolean match(TripleID pattern) {
        long subjectPattern = pattern.getSubject();
        long predicatePattern = pattern.getPredicate();
        long objectPattern = pattern.getObject();
        if (!(subjectPattern != 0L && (long)this.subject != subjectPattern || predicatePattern != 0L && (long)this.predicate != predicatePattern)) {
            return objectPattern == 0L || (long)this.object == objectPattern;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.subject == 0 && this.predicate == 0 && this.object == 0;
    }

    public boolean isValid() {
        return this.subject > 0 && this.predicate > 0 && this.object > 0;
    }

    public String getPatternString() {
        return "" + (this.subject == 0 ? (char)'?' : 'S') + (this.predicate == 0 ? (char)'?' : 'P') + (this.object == 0 ? (char)'?' : 'O');
    }

    public TripleID asTripleID() {
        return new TripleID((long)this.subject, (long)this.predicate, (long)this.object);
    }

    public static int size() {
        return 24;
    }
}

