/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.Bitmap375Big;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Map;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.PredicateIndex;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PredicateIndexArray
implements PredicateIndex {
    private static final Logger log = LoggerFactory.getLogger(PredicateIndexArray.class);
    BitmapTriples triples;
    Sequence array;
    Bitmap bitmap;

    public PredicateIndexArray(BitmapTriples triples) {
        this.triples = triples;
    }

    @Override
    public long getBase(long pred) {
        if (pred <= 1L) {
            return 0L;
        }
        return this.bitmap.select1(pred - 1L) + 1L;
    }

    @Override
    public long getNumOcurrences(long pred) {
        return this.bitmap.select1(pred) - this.bitmap.select1(pred - 1L);
    }

    @Override
    public long getOccurrence(long base, long occ) {
        return this.array.get(base + occ - 1L);
    }

    @Override
    public void load(InputStream input) throws IOException {
        this.bitmap = BitmapFactory.createBitmap((InputStream)input);
        this.bitmap.load(input, null);
        this.array = SequenceFactory.createStream(input);
        this.array.load(input, null);
    }

    @Override
    public void save(OutputStream out) throws IOException {
        this.bitmap.save(out, null);
        this.array.save(out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(ProgressListener listener, HDTOptions specIndex, Dictionary dictionary) {
        Bitmap375Big bitmap;
        long i;
        Path diskLocation;
        IntermediateListener iListener = new IntermediateListener(listener);
        StopWatch st = new StopWatch();
        if (this.triples.isUsingDiskSequence()) {
            try {
                diskLocation = this.triples.getDiskSequenceLocation().createOrGetPath();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't create disk sequence", e);
            }
        } else {
            diskLocation = null;
        }
        DynamicSequence predCount = this.triples.createSequence64(diskLocation, "predicateIndexPredCount", BitUtil.log2(this.triples.getSeqY().getNumberOfElements()), this.triples.getSeqY().getNumberOfElements());
        try {
            long maxCount = 0L;
            for (i = 0L; i < this.triples.getSeqY().getNumberOfElements(); ++i) {
                long val = this.triples.getSeqY().get(i);
                if (predCount.getNumberOfElements() < val) {
                    predCount.resize(val);
                }
                long count = predCount.get(val - 1L) + 1L;
                maxCount = Math.max(count, maxCount);
                predCount.set(val - 1L, count);
                if (listener == null || i % 1000000L != 0L) continue;
                listener.notifyProgress((float)(i * 100L / this.triples.getSeqY().getNumberOfElements()), "Counting appearances of predicates " + i + " / " + this.triples.getSeqY().getNumberOfElements());
            }
            predCount.aggressiveTrimToSize();
            bitmap = this.triples.createBitmap375(diskLocation, "predicateIndexBitmap", this.triples.getSeqY().getNumberOfElements());
            long tempCountPred = 0L;
            for (long i2 = 0L; i2 < predCount.getNumberOfElements(); ++i2) {
                bitmap.set((tempCountPred += predCount.get(i2)) - 1L, true);
                if (listener == null || i2 % 1000000L != 0L) continue;
                listener.notifyProgress((float)(i2 * 100L / predCount.getNumberOfElements()), "Creating Predicate bitmap " + i2 + " / " + this.triples.getSeqY().getNumberOfElements());
            }
            bitmap.set(this.triples.getSeqY().getNumberOfElements() - 1L, true);
            log.info("Predicate Bitmap in {}", (Object)st.stopAndShow());
            if (listener != null) {
                listener.notifyProgress(100.0f, "Predicate Bitmap in " + st);
            }
            st.reset();
        }
        finally {
            IOUtil.closeQuietly(predCount);
        }
        DynamicSequence array = this.triples.createSequence64(diskLocation, "predicateIndexArray", BitUtil.log2(this.triples.getSeqY().getNumberOfElements()), this.triples.getSeqY().getNumberOfElements());
        try {
            array.resize(this.triples.getSeqY().getNumberOfElements());
            DynamicSequence insertArray = this.triples.createSequence64(diskLocation, "predicateIndexInsertArray", BitUtil.log2(this.triples.getSeqY().getNumberOfElements()), bitmap.countOnes());
            try {
                insertArray.resize(bitmap.countOnes());
                for (i = 0L; i < this.triples.getSeqY().getNumberOfElements(); ++i) {
                    long predicateValue = this.triples.getSeqY().get(i);
                    long insertBase = predicateValue == 1L ? 0L : bitmap.select1(predicateValue - 1L) + 1L;
                    long insertOffset = insertArray.get(predicateValue - 1L);
                    insertArray.set(predicateValue - 1L, insertOffset + 1L);
                    array.set(insertBase + insertOffset, i);
                    if (listener == null || i % 1000000L != 0L) continue;
                    listener.notifyProgress((float)(i * 100L / this.triples.getSeqY().getNumberOfElements()), "Generating predicate references");
                }
            }
            finally {
                IOUtil.closeQuietly(insertArray);
            }
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(array);
                throw throwable;
            }
        }
        try {
            Closer.closeAll(this.array, this.bitmap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.array = array;
        this.bitmap = bitmap;
        log.info("Count predicates in {}", (Object)st.stopAndShow());
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ProgressListener listener) throws IOException {
        this.bitmap = BitmapFactory.createBitmap((InputStream)input);
        this.bitmap.load((InputStream)input, null);
        this.array = new SequenceLog64Map(input, f);
    }

    @Override
    public void close() throws IOException {
        try {
            Closer.closeAll(this.array, this.bitmap);
        }
        finally {
            this.bitmap = null;
            this.array = null;
        }
    }
}

