/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.util.HashMap;
import java.util.Map;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.triples.DictionaryEntriesDiff;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;

public class FourSectionDictionaryEntriesDiff
implements DictionaryEntriesDiff {
    private final HDT hdtOriginal;
    private final IteratorTripleID iterator;
    private final Bitmap bitArrayDisk;
    private final Map<CharSequence, ModifiableBitmap> bitmaps;
    private long count;

    public FourSectionDictionaryEntriesDiff(HDT hdtOriginal, Bitmap deleteBitmap, IteratorTripleID iterator) {
        this.hdtOriginal = hdtOriginal;
        this.iterator = iterator;
        this.bitArrayDisk = deleteBitmap;
        this.bitmaps = new HashMap<CharSequence, ModifiableBitmap>();
    }

    @Override
    public void loadBitmaps() {
        this.bitmaps.clear();
        this.count = 0L;
        Dictionary dict = this.hdtOriginal.getDictionary();
        this.bitmaps.put("P", BitmapFactory.createRWBitmap((long)dict.getPredicates().getNumberOfElements()));
        this.bitmaps.put("S", BitmapFactory.createRWBitmap((long)dict.getSubjects().getNumberOfElements()));
        this.bitmaps.put("O", BitmapFactory.createRWBitmap((long)dict.getObjects().getNumberOfElements()));
        this.bitmaps.put("SH_S", BitmapFactory.createRWBitmap((long)dict.getShared().getNumberOfElements()));
        this.bitmaps.put("SH_O", BitmapFactory.createRWBitmap((long)dict.getShared().getNumberOfElements()));
        while (this.iterator.hasNext()) {
            TripleID tripleID = (TripleID)this.iterator.next();
            this.count = this.iterator.getLastTriplePosition();
            if (this.bitArrayDisk.access(this.count)) continue;
            long predId = tripleID.getPredicate();
            long subjId = tripleID.getSubject();
            long objId = tripleID.getObject();
            this.bitmaps.get("P").set(predId - 1L, true);
            long numShared = this.hdtOriginal.getDictionary().getShared().getNumberOfElements();
            if (subjId <= numShared) {
                this.bitmaps.get("SH_S").set(subjId - 1L, true);
            } else {
                this.bitmaps.get("S").set(subjId - numShared - 1L, true);
            }
            if (objId <= numShared) {
                this.bitmaps.get("SH_O").set(objId - 1L, true);
                continue;
            }
            this.bitmaps.get("O").set(objId - numShared - 1L, true);
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Map<CharSequence, ModifiableBitmap> getBitmaps() {
        return this.bitmaps;
    }
}

