/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.file.PathUtils;
import org.rdfhdt.hdt.compact.bitmap.AdjacencyList;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.Bitmap375Big;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceFactory;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Big;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.hdt.impl.HDTDiskImporter;
import org.rdfhdt.hdt.hdt.impl.diskindex.DiskIndexSort;
import org.rdfhdt.hdt.hdt.impl.diskindex.ObjectAdjReader;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.iterator.SequentialSearchIteratorTripleID;
import org.rdfhdt.hdt.iterator.SuppliableIteratorTripleID;
import org.rdfhdt.hdt.iterator.utils.AsyncIteratorFetcher;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIterator;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorY;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorYFOQ;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorZ;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorZFOQ;
import org.rdfhdt.hdt.triples.impl.EmptyTriplesIterator;
import org.rdfhdt.hdt.triples.impl.PredicateIndex;
import org.rdfhdt.hdt.triples.impl.PredicateIndexArray;
import org.rdfhdt.hdt.triples.impl.TripleOrderConvert;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.concurrent.KWayMerger;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.Pair;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTriples
implements TriplesPrivate {
    private static final Logger log = LoggerFactory.getLogger(BitmapTriples.class);
    protected TripleComponentOrder order;
    protected Sequence seqY;
    protected Sequence seqZ;
    protected Sequence indexZ;
    protected Sequence predicateCount;
    protected Bitmap bitmapY;
    protected Bitmap bitmapZ;
    protected Bitmap bitmapIndexZ;
    protected AdjacencyList adjY;
    protected AdjacencyList adjZ;
    protected AdjacencyList adjIndex;
    public PredicateIndex predicateIndex;
    boolean diskSequence;
    boolean diskSubIndex;
    CreateOnUsePath diskSequenceLocation;
    private boolean isClosed;

    public BitmapTriples() throws IOException {
        this(new HDTSpecification());
    }

    public BitmapTriples(HDTOptions spec) throws IOException {
        String orderStr = spec.get("triplesOrder");
        this.order = orderStr == null ? TripleComponentOrder.SPO : TripleComponentOrder.valueOf((String)orderStr);
        this.loadDiskSequence(spec);
        this.bitmapY = BitmapFactory.createBitmap((String)spec.get("bitmap.y"));
        this.bitmapZ = BitmapFactory.createBitmap((String)spec.get("bitmap.z"));
        this.seqY = SequenceFactory.createStream(spec.get("seq.y"));
        this.seqZ = SequenceFactory.createStream(spec.get("seq.z"));
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    public BitmapTriples(HDTOptions spec, Sequence seqY, Sequence seqZ, Bitmap bitY, Bitmap bitZ, TripleComponentOrder order) throws IOException {
        this.seqY = seqY;
        this.seqZ = seqZ;
        this.bitmapY = bitY;
        this.bitmapZ = bitZ;
        this.order = order;
        this.loadDiskSequence(spec);
        this.adjY = new AdjacencyList(seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    private void loadDiskSequence(HDTOptions spec) throws IOException {
        this.diskSequence = spec != null && spec.getBoolean("bitmaptriples.sequence.disk", false);
        boolean bl = this.diskSubIndex = spec != null && spec.getBoolean("bitmaptriples.sequence.disk.subindex", false);
        if (this.diskSequenceLocation != null) {
            this.diskSequenceLocation.close();
        }
        if (this.diskSequence) {
            assert (spec != null);
            String optDiskLocation = spec.get("bitmaptriples.sequence.disk.location");
            this.diskSequenceLocation = optDiskLocation != null && !optDiskLocation.isEmpty() ? new CreateOnUsePath(Path.of(optDiskLocation, new String[0])) : new CreateOnUsePath();
        } else {
            this.diskSequenceLocation = null;
        }
    }

    public CreateOnUsePath getDiskSequenceLocation() {
        return this.diskSequenceLocation;
    }

    public boolean isUsingDiskSequence() {
        return this.diskSequence;
    }

    public PredicateIndex getPredicateIndex() {
        return this.predicateIndex;
    }

    public Sequence getPredicateCount() {
        return this.predicateCount;
    }

    public void load(IteratorTripleID it, ProgressListener listener) {
        long number = it.estimatedNumResults();
        SequenceLog64Big vectorY = new SequenceLog64Big(BitUtil.log2(number), number + 1L);
        SequenceLog64Big vectorZ = new SequenceLog64Big(BitUtil.log2(number), number + 1L);
        Bitmap375Big bitY = Bitmap375Big.memory(number);
        Bitmap375Big bitZ = Bitmap375Big.memory(number);
        long lastX = 0L;
        long lastY = 0L;
        long lastZ = 0L;
        long numTriples = 0L;
        while (it.hasNext()) {
            TripleID triple = (TripleID)it.next();
            TripleOrderConvert.swapComponentOrder(triple, TripleComponentOrder.SPO, this.order);
            long x = triple.getSubject();
            long y = triple.getPredicate();
            long z = triple.getObject();
            if (x == 0L || y == 0L || z == 0L) {
                throw new IllegalFormatException("None of the components of a triple can be null");
            }
            if (numTriples == 0L) {
                vectorY.append(y);
                vectorZ.append(z);
            } else if (x != lastX) {
                if (x != lastX + 1L) {
                    throw new IllegalFormatException("Upper level must be increasing and correlative.");
                }
                bitY.append(true);
                vectorY.append(y);
                bitZ.append(true);
                vectorZ.append(z);
            } else if (y != lastY) {
                if (y < lastY) {
                    throw new IllegalFormatException("Middle level must be increasing for each parent.");
                }
                bitY.append(false);
                vectorY.append(y);
                bitZ.append(true);
                vectorZ.append(z);
            } else {
                if (z < lastZ) {
                    throw new IllegalFormatException("Lower level must be increasing for each parent.");
                }
                bitZ.append(false);
                vectorZ.append(z);
            }
            lastX = x;
            lastY = y;
            lastZ = z;
            ListenerUtil.notifyCond(listener, "Converting to BitmapTriples", numTriples, numTriples, number);
            ++numTriples;
        }
        if (numTriples > 0L) {
            bitY.append(true);
            bitZ.append(true);
        }
        vectorY.aggressiveTrimToSize();
        vectorZ.trimToSize();
        this.seqY = vectorY;
        this.seqZ = vectorZ;
        this.bitmapY = bitY;
        this.bitmapZ = bitZ;
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    @Override
    public void load(TempTriples triples, ProgressListener listener) {
        triples.setOrder(this.order);
        triples.sort(listener);
        IteratorTripleID it = triples.searchAll();
        this.load(it, listener);
    }

    @Override
    public SuppliableIteratorTripleID search(TripleID pattern) {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot search on BitmapTriples if it's already closed");
        }
        if (this.getNumberOfElements() == 0L || pattern.isNoMatch()) {
            return new EmptyTriplesIterator(this.order);
        }
        TripleID reorderedPat = new TripleID(pattern);
        TripleOrderConvert.swapComponentOrder(reorderedPat, TripleComponentOrder.SPO, this.order);
        String patternString = reorderedPat.getPatternString();
        if (patternString.equals("?P?")) {
            if (this.predicateIndex != null) {
                return new BitmapTriplesIteratorYFOQ(this, pattern);
            }
            return new BitmapTriplesIteratorY(this, pattern);
        }
        if (this.indexZ != null && this.bitmapIndexZ != null) {
            if (patternString.equals("?PO") || patternString.equals("??O")) {
                return new BitmapTriplesIteratorZFOQ(this, pattern);
            }
        } else {
            if (patternString.equals("?PO")) {
                return new SequentialSearchIteratorTripleID(pattern, new BitmapTriplesIteratorZ(this, pattern));
            }
            if (patternString.equals("??O")) {
                return new BitmapTriplesIteratorZ(this, pattern);
            }
        }
        BitmapTriplesIterator bitIt = new BitmapTriplesIterator(this, pattern);
        if (patternString.equals("???") || patternString.equals("S??") || patternString.equals("SP?") || patternString.equals("SPO")) {
            return bitIt;
        }
        return new SequentialSearchIteratorTripleID(pattern, bitIt);
    }

    public IteratorTripleID searchAll() {
        return this.search(new TripleID());
    }

    public long getNumberOfElements() {
        if (this.isClosed) {
            return 0L;
        }
        return this.seqZ.getNumberOfElements();
    }

    public long size() {
        if (this.isClosed) {
            return 0L;
        }
        return this.seqY.size() + this.seqZ.size() + this.bitmapY.getSizeBytes() + this.bitmapZ.getSizeBytes();
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.clear();
        ci.setFormat(this.getType());
        ci.setInt("order", (long)this.order.ordinal());
        ci.setType(ControlInfo.Type.TRIPLES);
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY.save(output, (ProgressListener)iListener);
        this.bitmapZ.save(output, (ProgressListener)iListener);
        this.seqY.save(output, iListener);
        this.seqZ.save(output, iListener);
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        if (ci.getType() != ControlInfo.Type.TRIPLES) {
            throw new IllegalFormatException("Trying to read a triples section, but was not triples.");
        }
        if (!ci.getFormat().equals(this.getType())) {
            throw new IllegalFormatException("Trying to read BitmapTriples, but the data does not seem to be BitmapTriples");
        }
        this.order = TripleComponentOrder.values()[(int)ci.getInt("order")];
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY = BitmapFactory.createBitmap((InputStream)input);
        this.bitmapY.load(input, (ProgressListener)iListener);
        this.bitmapZ = BitmapFactory.createBitmap((InputStream)input);
        this.bitmapZ.load(input, (ProgressListener)iListener);
        this.seqY = SequenceFactory.createStream(input);
        this.seqY.load(input, iListener);
        this.seqZ = SequenceFactory.createStream(input);
        this.seqZ.load(input, iListener);
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    @Override
    public void mapFromFile(CountInputStream input, File f, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        ci.load(input);
        if (ci.getType() != ControlInfo.Type.TRIPLES) {
            throw new IllegalFormatException("Trying to read a triples section, but was not triples.");
        }
        if (!ci.getFormat().equals(this.getType())) {
            throw new IllegalFormatException("Trying to read BitmapTriples, but the data does not seem to be BitmapTriples");
        }
        this.order = TripleComponentOrder.values()[(int)ci.getInt("order")];
        IntermediateListener iListener = new IntermediateListener(listener);
        this.bitmapY = BitmapFactory.createBitmap((InputStream)input);
        this.bitmapY.load((InputStream)input, (ProgressListener)iListener);
        this.bitmapZ = BitmapFactory.createBitmap((InputStream)input);
        this.bitmapZ.load((InputStream)input, (ProgressListener)iListener);
        this.seqY = SequenceFactory.createStream(input, f);
        this.seqZ = SequenceFactory.createStream(input, f);
        this.adjY = new AdjacencyList(this.seqY, this.bitmapY);
        this.adjZ = new AdjacencyList(this.seqZ, this.bitmapZ);
        this.isClosed = false;
    }

    public DynamicSequence createSequence64(Path baseDir, String name, int size, long capacity, boolean forceDisk) throws IOException {
        if (forceDisk && !this.diskSequence) {
            final Path path = Files.createTempFile(name, ".bin", new FileAttribute[0]);
            return new SequenceLog64BigDisk(path, size, capacity, true){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        Files.deleteIfExists(path);
                    }
                }
            };
        }
        return this.createSequence64(baseDir, name, size, capacity);
    }

    public DynamicSequence createSequence64(Path baseDir, String name, int size, long capacity) {
        if (this.diskSequence) {
            final Path path = baseDir.resolve(name);
            return new SequenceLog64BigDisk(path, size, capacity, true){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        Files.deleteIfExists(path);
                    }
                }
            };
        }
        return new SequenceLog64Big(size, capacity, true);
    }

    public Bitmap375Big createBitmap375(Path baseDir, String name, long size) {
        if (this.diskSequence) {
            Path path = baseDir.resolve(name);
            Bitmap375Big bm = Bitmap375Big.disk(path, size, this.diskSubIndex);
            bm.getCloser().with(CloseSuppressPath.of(path), new Object[0]);
            return bm;
        }
        return Bitmap375Big.memory(size);
    }

    static long getMaxChunkSizeDiskIndex(int workers) {
        return (long)((double)HDTDiskImporter.getAvailableMemory() * 0.85 / (double)(3L * (long)workers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexObjectDisk(HDTOptions spec, Dictionary dictionary, ProgressListener plistener) throws IOException {
        MultiThreadListener listener = ListenerUtil.multiThreadListener(plistener);
        StopWatch global = new StopWatch();
        Path diskLocation = this.diskSequence ? this.diskSequenceLocation.createOrGetPath() : Files.createTempDirectory("bitmapTriples", new FileAttribute[0]);
        int workers = (int)spec.getInt("bitmaptriples.indexmethod.disk.compressWorker", Runtime.getRuntime()::availableProcessors);
        if (workers <= 0) {
            throw new IllegalArgumentException("Number of workers should be positive!");
        }
        long chunkSize = spec.getInt("bitmaptriples.indexmethod.disk.chunkSize", () -> BitmapTriples.getMaxChunkSizeDiskIndex(workers));
        if (chunkSize < 0L) {
            throw new IllegalArgumentException("Negative chunk size!");
        }
        long maxFileOpenedLong = spec.getInt("bitmaptriples.indexmethod.disk.maxFileOpen", 1024L);
        if (maxFileOpenedLong < 0L || maxFileOpenedLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxFileOpened should be positive!");
        }
        int maxFileOpened = (int)maxFileOpenedLong;
        long kwayLong = spec.getInt("bitmaptriples.indexmethod.disk.kway", () -> Math.max(1, BitUtil.log2(maxFileOpened / workers)));
        if (kwayLong <= 0L || kwayLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("kway can't be negative!");
        }
        int k = 1 << (int)kwayLong;
        long bufferSizeLong = spec.getInt("bitmaptriples.indexmethod.disk.fileBufferSize", 8192L);
        if (bufferSizeLong > 0x7FFFFFFAL || bufferSizeLong <= 0L) {
            throw new IllegalArgumentException("Buffer size can't be negative or bigger than the size of an array!");
        }
        int bufferSize = (int)bufferSizeLong;
        DiskIndexSort sort = new DiskIndexSort(CloseSuppressPath.of(diskLocation).resolve("chunks"), new AsyncIteratorFetcher<Pair>(new ObjectAdjReader(this.seqZ, this.seqY, this.bitmapZ)), listener, bufferSize, chunkSize, k, Comparator.comparingLong(p -> p.object).thenComparingLong(p -> p.predicate));
        DynamicSequence indexZ = null;
        Bitmap375Big bitmapIndexZ = null;
        DynamicSequence predCount = null;
        global.reset();
        try {
            try {
                ExceptionIterator<Pair, IOException> sortedPairs = sort.sort(workers);
                log.info("Pair sorted in {}", (Object)global.stopAndShow());
                global.reset();
                indexZ = this.createSequence64(diskLocation, "indexZ", BitUtil.log2(this.seqY.getNumberOfElements()), this.seqZ.getNumberOfElements());
                bitmapIndexZ = this.createBitmap375(diskLocation, "bitmapIndexZ", this.seqZ.getNumberOfElements());
                try {
                    long block;
                    long lastObj = -2L;
                    long index = 0L;
                    long size = Math.max(this.seqZ.getNumberOfElements(), 1L);
                    long l = block = size < 10L ? 1L : size / 10L;
                    while (sortedPairs.hasNext()) {
                        Pair pair = sortedPairs.next();
                        long object = pair.object;
                        long y = pair.predicatePosition;
                        if (lastObj == object - 1L) {
                            bitmapIndexZ.set(index - 1L, true);
                        } else if (lastObj != object) {
                            if (lastObj == -2L) {
                                if (object != 1L) {
                                    throw new IllegalArgumentException("Pair object start after 1! " + object);
                                }
                            } else {
                                throw new IllegalArgumentException("Non 1 increasing object! lastObj: " + lastObj + ", object: " + object);
                            }
                        }
                        lastObj = object;
                        if (index % block == 0L) {
                            listener.notifyProgress((float)index / ((float)block / 10.0f), "writing bitmapIndexZ/indexZ " + index + "/" + size);
                        }
                        indexZ.set(index, y);
                        ++index;
                    }
                    listener.notifyProgress(100.0f, "indexZ completed " + index);
                    bitmapIndexZ.set(index - 1L, true);
                }
                finally {
                    IOUtil.closeObject(sortedPairs);
                }
                log.info("indexZ/bitmapIndexZ completed in {}", (Object)global.stopAndShow());
            }
            catch (InterruptedException | KWayMerger.KWayMergerException e) {
                if (e.getCause() != null) {
                    IOUtil.throwIOOrRuntime(e.getCause());
                }
                throw new RuntimeException("Can't sort pairs", e);
            }
            global.reset();
            predCount = this.createSequence64(diskLocation, "predCount", BitUtil.log2(this.seqY.getNumberOfElements()), dictionary.getNpredicates());
            long size = Math.max(this.seqY.getNumberOfElements(), 1L);
            long block = size < 10L ? 1L : size / 10L;
            for (long i = 0L; i < this.seqY.getNumberOfElements(); ++i) {
                long val = this.seqY.get(i);
                if (i % block == 0L) {
                    listener.notifyProgress((float)i / ((float)block / 10.0f), "writing predCount " + i + "/" + size);
                }
                predCount.set(val - 1L, predCount.get(val - 1L) + 1L);
            }
            predCount.trimToSize();
            listener.notifyProgress(100.0f, "predCount completed " + this.seqY.getNumberOfElements());
            log.info("Predicate count completed in {}", (Object)global.stopAndShow());
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                Closer.closeAll(indexZ, bitmapIndexZ, predCount);
                throw throwable;
            }
        }
        this.predicateCount = predCount;
        this.indexZ = indexZ;
        this.bitmapIndexZ = bitmapIndexZ;
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
        log.info("Index generated in {}", (Object)global.stopAndShow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexObjectMemoryEfficient() throws IOException {
        Path diskLocation = this.diskSequence ? this.diskSequenceLocation.createOrGetPath() : null;
        StopWatch global = new StopWatch();
        StopWatch st = new StopWatch();
        long maxCount = 0L;
        long numDifferentObjects = 0L;
        long numReservedObjects = 8192L;
        Bitmap375Big bitmapIndex = null;
        Closeable predCount = null;
        Closeable objectArray = null;
        try {
            long i;
            try (DynamicSequence objectCount = this.createSequence64(diskLocation, "objectCount", BitUtil.log2(this.seqZ.getNumberOfElements()), numReservedObjects);){
                for (i = 0L; i < this.seqZ.getNumberOfElements(); ++i) {
                    long val = this.seqZ.get(i);
                    if (val == 0L) {
                        throw new RuntimeException("ERROR: There is a zero value in the Z level.");
                    }
                    if (numReservedObjects < val) {
                        while (numReservedObjects < val) {
                            numReservedObjects <<= 1;
                        }
                        objectCount.resize(numReservedObjects);
                    }
                    if (numDifferentObjects < val) {
                        numDifferentObjects = val;
                    }
                    long count = objectCount.get(val - 1L) + 1L;
                    maxCount = Math.max(count, maxCount);
                    objectCount.set(val - 1L, count);
                }
                log.info("Count Objects in {} Max was: {}", (Object)st.stopAndShow(), (Object)maxCount);
                st.reset();
                bitmapIndex = this.createBitmap375(diskLocation, "bitmapIndex", this.seqZ.getNumberOfElements());
                long tmpCount = 0L;
                for (long i2 = 0L; i2 < numDifferentObjects; ++i2) {
                    bitmapIndex.set((tmpCount += objectCount.get(i2)) - 1L, true);
                }
                bitmapIndex.set(this.seqZ.getNumberOfElements() - 1L, true);
                log.info("Bitmap in {}", (Object)st.stopAndShow());
            }
            st.reset();
            objectArray = this.createSequence64(diskLocation, "objectArray", BitUtil.log2(this.seqY.getNumberOfElements()), this.seqZ.getNumberOfElements(), true);
            objectArray.resize(this.seqZ.getNumberOfElements());
            try (DynamicSequence objectInsertedCount = this.createSequence64(diskLocation, "objectInsertedCount", BitUtil.log2(maxCount), numDifferentObjects);){
                objectInsertedCount.resize(numDifferentObjects);
                for (i = 0L; i < this.seqZ.getNumberOfElements(); ++i) {
                    long objectValue = this.seqZ.get(i);
                    long posY = i > 0L ? this.bitmapZ.rank1(i - 1L) : 0L;
                    long insertBase = objectValue == 1L ? 0L : bitmapIndex.select1(objectValue - 1L) + 1L;
                    long insertOffset = objectInsertedCount.get(objectValue - 1L);
                    objectInsertedCount.set(objectValue - 1L, insertOffset + 1L);
                    objectArray.set(insertBase + insertOffset, posY);
                }
                log.info("Object references in {}", (Object)st.stopAndShow());
            }
            st.reset();
            long object = 1L;
            long first = 0L;
            long last = bitmapIndex.selectNext1(first) + 1L;
            do {
                long listLen;
                if ((listLen = last - first) == 2L) {
                    long bPos;
                    long b;
                    long aPos = objectArray.get(first);
                    long a = this.seqY.get(aPos);
                    if (a > (b = this.seqY.get(bPos = objectArray.get(first + 1L)))) {
                        objectArray.set(first, bPos);
                        objectArray.set(first + 1L, aPos);
                    }
                } else if (listLen > 2L) {
                    long i3;
                    class Pair {
                        Long valueY;
                        Long positionY;

                        Pair() {
                        }

                        public String toString() {
                            return String.format("%d %d", this.valueY, this.positionY);
                        }
                    }
                    ArrayList<Pair> list = new ArrayList<Pair>((int)listLen);
                    for (i3 = first; i3 < last; ++i3) {
                        Pair p = new Pair();
                        p.positionY = objectArray.get(i3);
                        p.valueY = this.seqY.get(p.positionY);
                        list.add(p);
                    }
                    list.sort((o1, o2) -> {
                        if (o1.valueY.equals(o2.valueY)) {
                            return o1.positionY.compareTo(o2.positionY);
                        }
                        return o1.valueY.compareTo(o2.valueY);
                    });
                    for (i3 = first; i3 < last; ++i3) {
                        Pair pair = (Pair)list.get((int)(i3 - first));
                        objectArray.set(i3, pair.positionY);
                    }
                }
                first = last;
                last = bitmapIndex.selectNext1(first) + 1L;
            } while (++object <= numDifferentObjects);
            log.info("Sort object sublists in {}", (Object)st.stopAndShow());
            st.reset();
            predCount = this.createSequence64(diskLocation, "predCount", BitUtil.log2(this.seqY.getNumberOfElements()), 0L);
            for (long i4 = 0L; i4 < this.seqY.getNumberOfElements(); ++i4) {
                long val = this.seqY.get(i4);
                if (predCount.getNumberOfElements() < val) {
                    predCount.resize(val);
                }
                predCount.set(val - 1L, predCount.get(val - 1L) + 1L);
            }
            predCount.trimToSize();
            log.info("Count predicates in {}", (Object)st.stopAndShow());
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    IOUtil.closeObject(bitmapIndex);
                }
                finally {
                    try {
                        if (objectArray != null) {
                            objectArray.close();
                        }
                    }
                    finally {
                        if (predCount != null) {
                            predCount.close();
                        }
                    }
                }
                throw throwable;
            }
        }
        this.predicateCount = predCount;
        st.reset();
        this.indexZ = objectArray;
        this.bitmapIndexZ = bitmapIndex;
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
        log.info("Index generated in {}", (Object)global.stopAndShow());
    }

    private void createIndexObjects() {
        class Pair {
            int valueY;
            int positionY;

            Pair() {
            }
        }
        ArrayList<Pair> inner;
        ArrayList list = new ArrayList();
        System.out.println("Generating HDT Index for ?PO, and ??O queries.");
        long total = this.seqZ.getNumberOfElements();
        for (long i = 0L; i < total; ++i) {
            Pair pair = new Pair();
            pair.positionY = (int)this.adjZ.findListIndex(i);
            pair.valueY = (int)this.seqY.get(pair.positionY);
            long valueZ = this.seqZ.get(i);
            if (list.size() <= (int)valueZ) {
                list.ensureCapacity((int)valueZ);
                while ((long)list.size() < valueZ) {
                    list.add(new ArrayList(1));
                }
            }
            if ((inner = (List)list.get((int)valueZ - 1)) == null) {
                inner = new ArrayList<Pair>(1);
                list.set((int)valueZ - 1, inner);
            }
            inner.add(pair);
            if (i % 100000L != 0L) continue;
            System.out.println("Processed: " + i + " objects out of " + total);
        }
        System.out.println("Serialize object lists");
        SequenceLog64 indexZ = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()), list.size());
        Bitmap375Big bitmapIndexZ = Bitmap375Big.memory(this.seqY.getNumberOfElements());
        long pos = 0L;
        total = list.size();
        int i = 0;
        while ((long)i < total) {
            inner = (ArrayList<Pair>)list.get(i);
            inner.sort(Comparator.comparingInt(o -> o.valueY));
            for (int j = 0; j < inner.size(); ++j) {
                indexZ.append(((Pair)inner.get((int)j)).positionY);
                bitmapIndexZ.set(pos, j == inner.size() - 1);
                ++pos;
            }
            if (i % 100000 == 0) {
                System.out.println("Serialized: " + i + " lists out of " + total);
            }
            list.set(i, null);
            ++i;
        }
        SequenceLog64 predCount = new SequenceLog64(BitUtil.log2(this.seqY.getNumberOfElements()));
        for (long i2 = 0L; i2 < this.seqY.getNumberOfElements(); ++i2) {
            long val = this.seqY.get(i2);
            if (predCount.getNumberOfElements() < val) {
                predCount.resize(val);
            }
            predCount.set(val - 1L, predCount.get(val - 1L) + 1L);
        }
        predCount.trimToSize();
        this.predicateCount = predCount;
        this.indexZ = indexZ;
        this.bitmapIndexZ = bitmapIndexZ;
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
    }

    @Override
    public void generateIndex(ProgressListener listener, HDTOptions specIndex, Dictionary dictionary) throws IOException {
        String indexMethod;
        this.loadDiskSequence(specIndex);
        switch (indexMethod = specIndex.get("bitmaptriples.indexmethod", "recommended")) {
            case "recommended": 
            case "optimized": {
                this.createIndexObjectMemoryEfficient();
                break;
            }
            case "disk": {
                this.createIndexObjectDisk(specIndex, dictionary, listener);
                break;
            }
            case "legacy": {
                this.createIndexObjects();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown INDEXING METHOD: " + indexMethod);
            }
        }
        this.predicateIndex = new PredicateIndexArray(this);
        if (!specIndex.getBoolean("debug.bitmaptriples.ignorePredicateIndex", false)) {
            this.predicateIndex.generate(listener, specIndex, dictionary);
        } else {
            System.err.println("WARNING!!! PREDICATE INDEX IGNORED, THE INDEX WON'T BE COMPLETED!");
        }
    }

    public void populateHeader(Header header, String rootNode) {
        if (rootNode == null || rootNode.length() == 0) {
            throw new IllegalArgumentException("Root node for the header cannot be null");
        }
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesnumTriples>", this.getNumberOfElements());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#triplesOrder>", (CharSequence)this.order.toString());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#triplesBitmap>";
    }

    public TripleID findTriple(long position) {
        if (position == 0L) {
            return new TripleID(1L, this.seqY.get(0L), this.seqZ.get(0L));
        }
        long z = this.seqZ.get(position);
        long posY = this.bitmapZ.rank1(position - 1L);
        long y = this.seqY.get(posY);
        if (posY == 0L) {
            return new TripleID(1L, y, z);
        }
        long posX = this.bitmapY.rank1(posY - 1L);
        long x = posX + 1L;
        return new TripleID(x, y, z);
    }

    @Override
    public void saveIndex(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.setType(ControlInfo.Type.INDEX);
        ci.setInt("numTriples", this.getNumberOfElements());
        ci.setInt("order", (long)this.order.ordinal());
        ci.setFormat("<http://purl.org/HDT/hdt#indexFoQ>");
        ci.save(output);
        this.bitmapIndexZ.save(output, (ProgressListener)iListener);
        this.indexZ.save(output, iListener);
        this.predicateIndex.save(output);
        this.predicateCount.save(output, iListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadIndex(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        if (ci.getType() != ControlInfo.Type.INDEX) {
            throw new IllegalFormatException("Trying to read an Index Section but it was not an Index.");
        }
        if (!"<http://purl.org/HDT/hdt#indexFoQ>".equals(ci.getFormat())) {
            throw new IllegalFormatException("Trying to read wrong format of Index. Remove the .hdt.index file and let the app regenerate it.");
        }
        long numTriples = ci.getInt("numTriples");
        if (this.getNumberOfElements() != numTriples) {
            throw new IllegalFormatException("This index is not associated to the HDT file");
        }
        TripleComponentOrder indexOrder = TripleComponentOrder.values()[(int)ci.getInt("order")];
        if (indexOrder != this.order) {
            throw new IllegalFormatException("The order of the triples is not the same of the index.");
        }
        IOUtil.closeObject(this.bitmapIndexZ);
        this.bitmapIndexZ = null;
        this.bitmapIndexZ = BitmapFactory.createBitmap((InputStream)input);
        try {
            this.bitmapIndexZ.load(input, (ProgressListener)iListener);
            if (this.indexZ != null) {
                try {
                    this.indexZ.close();
                }
                finally {
                    this.indexZ = null;
                }
            }
            this.indexZ = SequenceFactory.createStream(input);
            try {
                this.indexZ.load(input, iListener);
                if (this.predicateIndex != null) {
                    try {
                        this.predicateIndex.close();
                    }
                    finally {
                        this.predicateIndex = null;
                    }
                }
                this.predicateIndex = new PredicateIndexArray(this);
                try {
                    this.predicateIndex.load(input);
                    if (this.predicateCount != null) {
                        try {
                            this.predicateCount.close();
                        }
                        finally {
                            this.predicateCount = null;
                        }
                    }
                    this.predicateCount = SequenceFactory.createStream(input);
                    try {
                        this.predicateCount.load(input, iListener);
                        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
                    }
                    catch (Throwable t) {
                        try {
                            this.predicateCount.close();
                        }
                        finally {
                            this.predicateCount = null;
                            this.adjIndex = null;
                        }
                        throw t;
                    }
                }
                catch (Throwable t) {
                    try {
                        this.predicateIndex.close();
                    }
                    finally {
                        this.predicateIndex = null;
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                try {
                    this.indexZ.close();
                }
                finally {
                    this.indexZ = null;
                }
                throw t;
            }
        }
        catch (Throwable t) {
            try {
                IOUtil.closeObject(this.bitmapIndexZ);
            }
            finally {
                this.bitmapIndexZ = null;
            }
            throw t;
        }
    }

    @Override
    public void mapIndex(CountInputStream input, File f, ControlInfo ci, ProgressListener listener) throws IOException {
        IntermediateListener iListener = new IntermediateListener(listener);
        if (ci.getType() != ControlInfo.Type.INDEX) {
            throw new IllegalFormatException("Trying to read an Index Section but it was not an Index.");
        }
        if (!"<http://purl.org/HDT/hdt#indexFoQ>".equals(ci.getFormat())) {
            throw new IllegalFormatException("Trying to read wrong format of Index. Remove the .hdt.index file and let the app regenerate it.");
        }
        long numTriples = ci.getInt("numTriples");
        if (this.getNumberOfElements() != numTriples) {
            throw new IllegalFormatException("This index is not associated to the HDT file");
        }
        TripleComponentOrder indexOrder = TripleComponentOrder.values()[(int)ci.getInt("order")];
        if (indexOrder != this.order) {
            throw new IllegalFormatException("The order of the triples is not the same of the index.");
        }
        this.bitmapIndexZ = BitmapFactory.createBitmap((InputStream)input);
        this.bitmapIndexZ.load((InputStream)input, (ProgressListener)iListener);
        this.indexZ = SequenceFactory.createStream(input, f);
        if (this.predicateIndex != null) {
            this.predicateIndex.close();
        }
        this.predicateIndex = new PredicateIndexArray(this);
        this.predicateIndex.mapIndex(input, f, iListener);
        this.predicateCount = SequenceFactory.createStream(input, f);
        this.adjIndex = new AdjacencyList(this.indexZ, this.bitmapIndexZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block141: {
            this.isClosed = true;
            try {
                if (this.diskSequenceLocation == null) break block141;
                try {
                    this.diskSequenceLocation.close();
                }
                finally {
                    this.diskSequenceLocation = null;
                }
            }
            finally {
                try {
                    if (this.seqY != null) {
                        this.seqY.close();
                        this.seqY = null;
                    }
                }
                finally {
                    try {
                        if (this.seqZ != null) {
                            this.seqZ.close();
                            this.seqZ = null;
                        }
                    }
                    finally {
                        try {
                            if (this.indexZ != null) {
                                this.indexZ.close();
                                this.indexZ = null;
                            }
                        }
                        finally {
                            try {
                                if (this.predicateCount != null) {
                                    this.predicateCount.close();
                                    this.predicateCount = null;
                                }
                            }
                            finally {
                                try {
                                    if (this.predicateIndex != null) {
                                        this.predicateIndex.close();
                                        this.predicateIndex = null;
                                    }
                                }
                                finally {
                                    if (this.bitmapIndexZ instanceof Closeable) {
                                        ((Closeable)this.bitmapIndexZ).close();
                                        this.bitmapIndexZ = null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public TripleComponentOrder getOrder() {
        return this.order;
    }

    public Sequence getIndexZ() {
        return this.indexZ;
    }

    public Sequence getSeqY() {
        return this.seqY;
    }

    public Sequence getSeqZ() {
        return this.seqZ;
    }

    public Bitmap getBitmapY() {
        return this.bitmapY;
    }

    public Bitmap getBitmapZ() {
        return this.bitmapZ;
    }

    public Bitmap getBitmapIndex() {
        return this.bitmapIndexZ;
    }

    public static class CreateOnUsePath
    implements Closeable {
        boolean mkdir;
        Path path;

        private CreateOnUsePath() {
            this(null);
        }

        private CreateOnUsePath(Path path) {
            this.path = path;
        }

        public Path createOrGetPath() throws IOException {
            if (this.path == null) {
                this.path = Files.createTempDirectory("bitmapTriple", new FileAttribute[0]);
            } else {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            return this.path;
        }

        @Override
        public void close() throws IOException {
            if (this.mkdir) {
                PathUtils.deleteDirectory((Path)this.path);
            }
        }
    }
}

