/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.triples;

import java.util.Comparator;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.impl.TripleIDInt;

public class TripleIDComparatorInt
implements Comparator<TripleIDInt> {
    private final TripleComponentOrder order;

    public static Comparator<TripleIDInt> getComparator(TripleComponentOrder order) {
        return new TripleIDComparatorInt(order);
    }

    private TripleIDComparatorInt(TripleComponentOrder order) {
        this.order = order;
    }

    @Override
    public int compare(TripleIDInt o1, TripleIDInt o2) {
        int x1 = 0;
        int y1 = 0;
        int z1 = 0;
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        switch (this.order) {
            case SPO: {
                x1 = o1.getSubject();
                x2 = o2.getSubject();
                y1 = o1.getPredicate();
                y2 = o2.getPredicate();
                z1 = o1.getObject();
                z2 = o2.getObject();
                break;
            }
            case SOP: {
                x1 = o1.getSubject();
                x2 = o2.getSubject();
                y1 = o1.getObject();
                y2 = o2.getObject();
                z1 = o1.getPredicate();
                z2 = o2.getPredicate();
                break;
            }
            case PSO: {
                x1 = o1.getPredicate();
                x2 = o2.getPredicate();
                y1 = o1.getSubject();
                y2 = o2.getSubject();
                z1 = o1.getObject();
                z2 = o2.getObject();
                break;
            }
            case POS: {
                x1 = o1.getPredicate();
                x2 = o2.getPredicate();
                y1 = o1.getObject();
                y2 = o2.getObject();
                z1 = o1.getSubject();
                z2 = o2.getSubject();
                break;
            }
            case OSP: {
                x1 = o1.getObject();
                x2 = o2.getObject();
                y1 = o1.getSubject();
                y2 = o2.getSubject();
                z1 = o1.getPredicate();
                z2 = o2.getPredicate();
                break;
            }
            case OPS: {
                x1 = o1.getObject();
                x2 = o2.getObject();
                y1 = o1.getPredicate();
                y2 = o2.getPredicate();
                z1 = o1.getSubject();
                z2 = o2.getSubject();
            }
        }
        int result = x1 - x2;
        if (result == 0) {
            result = y1 - y2;
            if (result == 0) {
                return z1 - z2;
            }
            return result;
        }
        return result;
    }
}

