/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.NonCloseInputStream;

public class RDFParserZip
implements RDFParserCallback {
    private final HDTOptions spec;

    public RDFParserZip(HDTOptions spec) {
        this.spec = spec;
    }

    public RDFParserZip() {
        this(HDTOptions.EMPTY);
    }

    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            this.doParse(input, baseUri, notation, keepBNode, callback);
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParserException();
        }
    }

    public void doParse(InputStream input, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zin = new ZipInputStream(input);
            NonCloseInputStream nonCloseIn = new NonCloseInputStream(zin);
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                try {
                    RDFNotation guessnot = RDFNotation.guess((String)zipEntry.getName());
                    System.out.println("Parse from zip: " + zipEntry.getName() + " as " + guessnot);
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot, this.spec);
                    parser.doParse((InputStream)nonCloseIn, baseUri, guessnot, keepBNode, callback);
                }
                catch (IllegalArgumentException | ParserException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParserException((Throwable)e);
        }
    }
}

