/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.NonCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserTar
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserTar.class);
    private final HDTOptions spec;

    public RDFParserTar(HDTOptions spec) {
        this.spec = spec;
    }

    public RDFParserTar() {
        this(HDTOptions.EMPTY);
    }

    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            InputStream input = IOUtil.getFileInputStream(fileName);
            this.doParse(input, baseUri, notation, keepBNode, callback);
            input.close();
        }
        catch (Exception e) {
            log.error("Unexpected exception parsing file: {}", (Object)fileName, (Object)e);
            throw new ParserException();
        }
    }

    public void doParse(InputStream input, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", input);
            TarArchiveEntry entry = null;
            NonCloseInputStream nonCloseIn = new NonCloseInputStream((InputStream)debInputStream);
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                if (!entry.isFile() || entry.getName().contains("DS_Store")) continue;
                try {
                    RDFNotation guessnot = RDFNotation.guess((String)entry.getName());
                    log.info("Parse from tar: {} as {}", (Object)entry.getName(), (Object)guessnot);
                    RDFParserCallback parser = RDFParserFactory.getParserCallback(guessnot, this.spec);
                    parser.doParse((InputStream)nonCloseIn, baseUri, guessnot, keepBNode, callback);
                }
                catch (IllegalArgumentException | ParserException e1) {
                    log.error("Unexpected exception.", e1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParserException();
        }
    }
}

