/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserSimple
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserSimple.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader;
        try {
            reader = IOUtil.getFileReader(fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParserException((Throwable)e);
        }
        try {
            this.doParse(reader, baseUri, notation, keepBNode, callback);
        }
        finally {
            IOUtil.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParse(InputStream input, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            this.doParse(reader, baseUri, notation, keepBNode, callback);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void doParse(BufferedReader reader, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            String line;
            long numLine = 1L;
            TripleString triple = new TripleString();
            while ((line = reader.readLine()) != null) {
                char c;
                int end;
                char c2;
                int start;
                for (start = 0; start < line.length() && ((c2 = line.charAt(start)) == ' ' || c2 == '\t'); ++start) {
                }
                for (end = line.length() - 1; end >= 0 && ((c = line.charAt(end)) == ' ' || c == '\t'); --end) {
                }
                if (start + 1 < end && line.charAt(start) != '#') {
                    triple.read(line, start, end);
                    if (!triple.hasEmpty()) {
                        callback.processTriple(triple, 0L);
                    } else {
                        System.err.println("Warning: Could not parse triple at line " + numLine + ", ignored and not processed.\n" + line);
                    }
                }
                ++numLine;
            }
            reader.close();
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new ParserException((Throwable)e);
        }
    }
}

