/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserHDT
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserHDT.class);

    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try (HDT hdt = HDTManager.mapHDT((String)fileName);){
            hdt.search((CharSequence)"", (CharSequence)"", (CharSequence)"").forEachRemaining(t -> callback.processTriple(t, 0L));
        }
        catch (IOException | NotFoundException e) {
            log.error("Unexpected exception.", e);
            throw new ParserException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doParse(InputStream in, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            Path tempFile = Files.createTempFile("hdtjava-reader", ".hdt", new FileAttribute[0]);
            log.warn("Create temp file to store the HDT stream {}", (Object)tempFile);
            try {
                Files.copy(in, tempFile, new CopyOption[0]);
                this.doParse(tempFile.toAbsolutePath().toString(), baseUri, notation, keepBNode, callback);
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
        }
        catch (IOException e) {
            log.error("Unexpected exception.", (Throwable)e);
            throw new ParserException((Throwable)e);
        }
    }
}

