/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.util.ContainerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParserDir
implements RDFParserCallback {
    private static final Logger log = LoggerFactory.getLogger(RDFParserDir.class);
    private final HDTOptions spec;
    final int async;

    public RDFParserDir(HDTOptions spec) {
        this.spec = spec;
        long dirAsyncValue = spec.getInt("parser.dir.async", 1L);
        if (dirAsyncValue == 0L) {
            this.async = Runtime.getRuntime().availableProcessors();
        } else {
            if (dirAsyncValue < 0L || dirAsyncValue >= 0x7FFFFFFAL) {
                throw new IllegalArgumentException("Invalid value for parser.dir.async: " + dirAsyncValue);
            }
            this.async = (int)dirAsyncValue;
        }
    }

    public RDFParserDir() {
        this(HDTOptions.EMPTY);
    }

    public void doParse(String fileName, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        try {
            this.doParse(Path.of(fileName, new String[0]), baseUri, notation, keepBNode, callback);
        }
        catch (InvalidPathException e) {
            throw new ParserException((Throwable)e);
        }
    }

    private void doParse(Path path, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        block17: {
            if (notation != RDFNotation.DIR) {
                throw new IllegalArgumentException("Can't parse notation different than " + RDFNotation.DIR + "!");
            }
            if (this.async == 1) {
                try (Stream<Path> subFiles = Files.list(path);){
                    subFiles.forEach(child -> {
                        try {
                            RDFParserCallback rdfParserCallback;
                            RDFNotation childNotation;
                            if (Files.isDirectory(child, new LinkOption[0])) {
                                this.doParse((Path)child, baseUri, RDFNotation.DIR, keepBNode, callback);
                                return;
                            }
                            try {
                                childNotation = RDFNotation.guess((File)child.toFile());
                                rdfParserCallback = RDFParserFactory.getParserCallback(childNotation, this.spec);
                            }
                            catch (IllegalArgumentException e) {
                                log.warn("Ignore file {}", child, (Object)e);
                                return;
                            }
                            log.debug("parse {}", child);
                            rdfParserCallback.doParse(child.toAbsolutePath().toString(), baseUri, childNotation, keepBNode, callback);
                        }
                        catch (ParserException e) {
                            throw new ContainerException(e);
                        }
                    });
                    break block17;
                }
                catch (IOException | SecurityException e) {
                    throw new ParserException((Throwable)e);
                }
                catch (ContainerException e) {
                    throw (ParserException)e.getCause();
                }
            }
            RDFParserCallback.RDFCallback asyncRdfCallback = callback.async();
            ExecutorService executorService = Executors.newFixedThreadPool(this.async);
            FutureList list = new FutureList();
            list.add(executorService.submit(new LoadTask(executorService, path, baseUri, RDFNotation.DIR, keepBNode, asyncRdfCallback)));
            try {
                list.await();
            }
            catch (ExecutionException e) {
                throw new ParserException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new ParserException((Throwable)e);
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    public void doParse(InputStream in, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) throws ParserException {
        throw new NotImplementedException("Can't parse a stream of directory!");
    }

    private class LoadTask
    implements Callable<FutureList> {
        private final ExecutorService executorService;
        private final Path path;
        private final String baseUri;
        private final RDFNotation notation;
        private final boolean keepBNode;
        private final RDFParserCallback.RDFCallback callback;

        private LoadTask(ExecutorService executorService, Path path, String baseUri, RDFNotation notation, boolean keepBNode, RDFParserCallback.RDFCallback callback) {
            this.executorService = executorService;
            this.path = path;
            this.baseUri = baseUri;
            this.notation = notation;
            this.keepBNode = keepBNode;
            this.callback = callback;
        }

        @Override
        public FutureList call() throws ParserException {
            FutureList list;
            block12: {
                RDFParserCallback rdfParserCallback;
                list = new FutureList();
                if (this.notation == RDFNotation.DIR) {
                    try (Stream<Path> subFiles = Files.list(this.path);){
                        subFiles.forEach(child -> {
                            RDFNotation childNotation;
                            if (Files.isDirectory(child, new LinkOption[0])) {
                                list.add(this.executorService.submit(new LoadTask(this.executorService, (Path)child, this.baseUri, RDFNotation.DIR, this.keepBNode, this.callback)));
                                return;
                            }
                            try {
                                childNotation = RDFNotation.guess((File)child.toFile());
                            }
                            catch (IllegalArgumentException e) {
                                log.warn("Ignore file {}", child, (Object)e);
                                return;
                            }
                            log.debug("parse {}", child);
                            list.add(this.executorService.submit(new LoadTask(this.executorService, (Path)child, this.baseUri, childNotation, this.keepBNode, this.callback)));
                        });
                        break block12;
                    }
                    catch (IOException | SecurityException e) {
                        throw new ParserException((Throwable)e);
                    }
                    catch (ContainerException e) {
                        throw (ParserException)e.getCause();
                    }
                }
                try {
                    rdfParserCallback = RDFParserFactory.getParserCallback(this.notation, RDFParserDir.this.spec);
                }
                catch (IllegalArgumentException | NotImplementedException e) {
                    log.warn("Ignore file {}", (Object)this.path, (Object)e);
                    return list;
                }
                log.debug("parse {}", (Object)this.path);
                rdfParserCallback.doParse(this.path.toAbsolutePath().toString(), this.baseUri, this.notation, this.keepBNode, this.callback);
            }
            return list;
        }
    }

    private static class FutureList {
        private final List<Future<FutureList>> list = new ArrayList<Future<FutureList>>();

        private FutureList() {
        }

        public void add(Future<FutureList> e) {
            this.list.add(e);
        }

        public void await() throws ExecutionException, InterruptedException {
            while (!this.list.isEmpty()) {
                Future<FutureList> future = this.list.remove(this.list.size() - 1);
                try {
                    this.mergeWith(future.get());
                }
                catch (InterruptedException e) {
                    if (!Thread.interrupted()) continue;
                    throw e;
                }
            }
        }

        public void mergeWith(FutureList other) {
            this.list.addAll(other.list);
        }
    }
}

