/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf.parsers;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class JenaNodeCreator {
    private JenaNodeCreator() {
    }

    public static Node create(CharSequence x) {
        String str = x.toString();
        if (str.length() == 0) {
            return JenaNodeCreator.createURI("");
        }
        char firstChar = str.charAt(0);
        if (firstChar == '_') {
            return JenaNodeCreator.createAnon(str);
        }
        if (firstChar == '\"') {
            return JenaNodeCreator.createLiteral(str);
        }
        return JenaNodeCreator.createURI(str);
    }

    public static Node createAnon(String str) {
        return NodeFactory.createBlankNode((String)str.substring(2));
    }

    public static Node createLiteral(String str) {
        int len = str.length();
        int next = 0;
        for (int i = len - 1; i > 0; --i) {
            char cur = str.charAt(i);
            if (cur == '\"') {
                if (next == 64) {
                    String literal = str.substring(1, i);
                    String lang = str.substring(i + 2, len);
                    return NodeFactory.createLiteral((String)literal, (String)lang);
                }
                String literal = str.substring(1, i);
                return NodeFactory.createLiteral((String)literal);
            }
            if (cur == '^' && next == 94 && str.charAt(i - 1) == '\"') {
                String literal = str.substring(1, i - 1);
                String datatype = str.charAt(i + 2) == '<' && str.charAt(len - 1) == '>' ? str.substring(i + 3, len - 1) : str.substring(i + 2, len);
                RDFDatatype rdfDataType = TypeMapper.getInstance().getSafeTypeByName(datatype);
                return NodeFactory.createLiteral((String)literal, (RDFDatatype)rdfDataType);
            }
            next = cur;
        }
        return NodeFactory.createLiteral((String)str.substring(1, len - 2));
    }

    public static Node createURI(String str) {
        return NodeFactory.createURI((String)str);
    }
}

