/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.rdf;

import java.io.InputStream;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.iterator.utils.PipedCopyIterator;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.parsers.RDFParserDir;
import org.rdfhdt.hdt.rdf.parsers.RDFParserHDT;
import org.rdfhdt.hdt.rdf.parsers.RDFParserList;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRAR;
import org.rdfhdt.hdt.rdf.parsers.RDFParserRIOT;
import org.rdfhdt.hdt.rdf.parsers.RDFParserSimple;
import org.rdfhdt.hdt.rdf.parsers.RDFParserTar;
import org.rdfhdt.hdt.rdf.parsers.RDFParserZip;
import org.rdfhdt.hdt.triples.TripleString;

public class RDFParserFactory {
    public static boolean useSimple(HDTOptions options) {
        return options != null && options.getBoolean("parser.ntSimpleParser", false);
    }

    public static RDFParserCallback getParserCallback(RDFNotation notation) {
        return RDFParserFactory.getParserCallback(notation, HDTOptions.EMPTY);
    }

    public static RDFParserCallback getParserCallback(RDFNotation notation, HDTOptions spec) {
        switch (notation) {
            case NTRIPLES: {
                if (RDFParserFactory.useSimple(spec)) {
                    return new RDFParserSimple();
                }
            }
            case NQUAD: 
            case TURTLE: 
            case N3: 
            case RDFXML: {
                return new RDFParserRIOT();
            }
            case DIR: {
                return new RDFParserDir(spec);
            }
            case LIST: {
                return new RDFParserList(spec);
            }
            case ZIP: {
                return new RDFParserZip(spec);
            }
            case TAR: {
                return new RDFParserTar(spec);
            }
            case RAR: {
                return new RDFParserRAR(spec);
            }
            case HDT: {
                return new RDFParserHDT();
            }
            case JSONLD: {
                throw new NotImplementedException("RDFParserJSONLD not implemented");
            }
        }
        throw new NotImplementedException("Parser not found for notation: " + notation);
    }

    public static PipedCopyIterator<TripleString> readAsIterator(RDFParserCallback parser, InputStream stream, String baseUri, boolean keepBNode, RDFNotation notation) {
        return PipedCopyIterator.createOfCallback(pipe -> parser.doParse(stream, baseUri, notation, keepBNode, (triple, pos) -> pipe.addElement(triple.tripleToString())));
    }
}

