/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.rdfhdt.hdt.options.HDTOptions;

public class HideHDTOptions
implements HDTOptions {
    private final HDTOptions spec;
    private final Function<String, String> mapper;
    private final Map<String, String> customOptions = new HashMap<String, String>();

    public HideHDTOptions(HDTOptions spec) {
        this(spec, Function.identity());
    }

    public HideHDTOptions(HDTOptions spec, Function<String, String> mapper) {
        this.spec = spec;
        this.mapper = mapper;
    }

    public void overrideValue(String key, Object value) {
        if (value != null) {
            this.customOptions.put(key, String.valueOf(value));
        } else {
            this.customOptions.remove(key);
        }
    }

    public Set<?> getKeys() {
        return this.spec.getKeys();
    }

    private String map(String key) {
        return Objects.requireNonNullElse(this.mapper.apply(key), "");
    }

    public String get(String key) {
        String newKey = this.map(key);
        String overrideValue = this.customOptions.get(newKey);
        return overrideValue != null ? overrideValue : this.spec.get(newKey);
    }

    public void set(String key, String value) {
        this.spec.set(this.map(key), value);
    }

    public void clear() {
        this.spec.clear();
    }
}

