/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.rdfhdt.hdt.iterator.utils.FileTripleIterator;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;

public class SizeFetcher<E>
implements Supplier<E> {
    private final Supplier<E> supplier;
    private final ToLongFunction<E> sizeGetter;
    private final long maxSize;
    private long size;

    public static SizeFetcher<TripleString> ofTripleString(Supplier<TripleString> supplier, long maxSize) {
        return SizeFetcher.of(supplier, FileTripleIterator::estimateSize, maxSize);
    }

    public static SizeFetcher<TripleID> ofTripleLong(Supplier<TripleID> supplier, long maxSize) {
        return SizeFetcher.of(supplier, tripleID -> 32L, maxSize);
    }

    public static <E> SizeFetcher<E> of(Supplier<E> supplier, ToLongFunction<E> sizeGetter, long maxSize) {
        return new SizeFetcher<E>(supplier, sizeGetter, maxSize);
    }

    public SizeFetcher(Supplier<E> supplier, ToLongFunction<E> sizeGetter, long maxSize) {
        this.supplier = supplier;
        this.sizeGetter = sizeGetter;
        this.maxSize = maxSize;
    }

    @Override
    public E get() {
        if (!this.canContinue()) {
            return null;
        }
        E e = this.supplier.get();
        if (e == null) {
            return null;
        }
        this.size += this.sizeGetter.applyAsLong(e);
        return e;
    }

    private boolean canContinue() {
        return this.size < this.maxSize;
    }

    public long getSize() {
        return this.size;
    }
}

