/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.MapIterator;

public class PipedCopyIterator<T>
implements Iterator<T>,
Closeable {
    private final ArrayBlockingQueue<QueueObject<T>> queue = new ArrayBlockingQueue(16);
    private T next;
    private boolean end;
    private PipedIteratorException exception;
    private Thread thread;

    public static <T> PipedCopyIterator<T> createOfCallback(PipeCallBack<T> callbackRunner) {
        PipedCopyIterator pipe = new PipedCopyIterator();
        Thread thread = new Thread(() -> {
            try {
                callbackRunner.createPipe(pipe);
                pipe.closePipe();
            }
            catch (Throwable e) {
                pipe.closePipe(e);
            }
        }, "PipeIterator");
        thread.start();
        pipe.attachThread(thread);
        return pipe;
    }

    @Override
    public boolean hasNext() {
        QueueObject<T> obj;
        if (this.end) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        try {
            obj = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new PipedIteratorException("Can't read pipe", e);
        }
        if (obj.end()) {
            this.end = true;
            if (this.exception != null) {
                throw this.exception;
            }
            return false;
        }
        this.next = obj.get();
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        T next = this.next;
        this.next = null;
        return next;
    }

    public void closePipe() {
        this.closePipe(null);
    }

    public void closePipe(Throwable e) {
        if (e != null) {
            this.queue.clear();
            this.exception = e instanceof PipedIteratorException ? (PipedIteratorException)e : new PipedIteratorException("closing exception", e);
        }
        try {
            this.queue.put(new EndQueueObject());
        }
        catch (InterruptedException ee) {
            throw new PipedIteratorException("Can't close pipe", ee);
        }
    }

    public <E> Iterator<E> map(Function<T, E> mappingFunction) {
        return new MapIterator<T, E>(this, mappingFunction);
    }

    public <E> Iterator<E> mapWithId(MapIterator.MapWithIdFunction<T, E> mappingFunction) {
        return new MapIterator<T, E>(this, mappingFunction);
    }

    public void addElement(T node) {
        try {
            this.queue.put(new ElementQueueObject(node));
        }
        catch (InterruptedException ee) {
            throw new PipedIteratorException("Can't add element to pipe", ee);
        }
    }

    public void attachThread(Thread thread) {
        Objects.requireNonNull(thread, "thread can't be null!");
        if (this.thread != null && this.thread != thread) {
            throw new IllegalArgumentException("Thread already attached");
        }
        this.thread = thread;
    }

    public void reset() {
        this.end = false;
    }

    @Override
    public void close() throws IOException {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    private class EndQueueObject
    implements QueueObject<T> {
        private EndQueueObject() {
        }

        @Override
        public boolean end() {
            return true;
        }

        @Override
        public T get() {
            throw new IllegalArgumentException();
        }
    }

    private class ElementQueueObject
    implements QueueObject<T> {
        private final T obj;

        private ElementQueueObject(T obj) {
            this.obj = obj;
        }

        @Override
        public boolean end() {
            return false;
        }

        @Override
        public T get() {
            return this.obj;
        }
    }

    private static interface QueueObject<T> {
        public boolean end();

        public T get();
    }

    @FunctionalInterface
    public static interface PipeCallBack<T> {
        public void createPipe(PipedCopyIterator<T> var1) throws Exception;
    }

    public static class PipedIteratorException
    extends RuntimeException {
        public PipedIteratorException(String message, Throwable t) {
            super(message, t);
        }
    }
}

