/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.MapIterator;

public class PeekIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    private T next;

    public PeekIterator(Iterator<T> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.it.hasNext()) {
            return false;
        }
        this.next = this.it.next();
        return true;
    }

    @Override
    public T next() {
        try {
            T t = this.peek();
            return t;
        }
        finally {
            this.next = null;
        }
    }

    public T peek() {
        if (this.hasNext()) {
            return this.next;
        }
        return null;
    }

    public <M> Iterator<M> map(Function<T, M> mappingFunction) {
        return new MapIterator<T, M>(this, mappingFunction);
    }

    public Iterator<T> getWrappedIterator() {
        return this.it;
    }
}

