/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Objects;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.listener.ProgressListener;

public class NotificationExceptionIterator<T, E extends Exception>
implements ExceptionIterator<T, E> {
    private final ExceptionIterator<T, E> it;
    private final long size;
    private final long split;
    private final String message;
    private final ProgressListener listener;
    private long current = 0L;

    public NotificationExceptionIterator(ExceptionIterator<T, E> it, long size, long split, String message, ProgressListener listener) {
        this.it = Objects.requireNonNull(it, "it can't be null!");
        if (size < 0L) {
            throw new IllegalArgumentException("size can't be negative!");
        }
        if (split < 0L) {
            throw new IllegalArgumentException("split can't be negative! " + split);
        }
        this.size = Math.max(1L, size);
        this.split = Math.max(1L, Math.min(split, size));
        this.message = Objects.requireNonNull(message, "message can't be null!");
        this.listener = Objects.requireNonNullElseGet(listener, () -> (perc, msg) -> {});
    }

    @Override
    public boolean hasNext() throws E {
        return this.it.hasNext();
    }

    @Override
    public T next() throws E {
        ++this.current;
        if (this.current % (this.size / this.split) == 0L) {
            this.listener.notifyProgress(100.0f * (float)this.current / (float)this.size, this.message + " " + this.current + "/" + this.size);
        }
        return this.it.next();
    }

    @Override
    public void remove() throws E {
        this.it.remove();
    }

    @Override
    public long getSize() {
        return this.it.getSize();
    }
}

