/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;

public class MergeExceptionIterator<T, E extends Exception>
implements ExceptionIterator<T, E> {
    private final ExceptionIterator<T, E> in1;
    private final ExceptionIterator<T, E> in2;
    private final Comparator<T> comp;
    private T next;
    private T prevE1;
    private T prevE2;

    public static <I, T, E extends Exception> ExceptionIterator<T, E> buildOfTree(Function<I, ExceptionIterator<T, E>> itFunction, Comparator<T> comp, I[] array, int length) {
        return MergeExceptionIterator.buildOfTree(itFunction, comp, array, 0, length);
    }

    public static <I, T, E extends Exception> ExceptionIterator<T, E> buildOfTree(Function<I, ExceptionIterator<T, E>> itFunction, Comparator<T> comp, I[] array, int start, int end) {
        return MergeExceptionIterator.buildOfTree(itFunction, comp, Arrays.asList(array), start, end);
    }

    public static <I, T, E extends Exception> ExceptionIterator<T, E> buildOfTree(Function<I, ExceptionIterator<T, E>> itFunction, Comparator<T> comp, List<I> array, int start, int end) {
        return MergeExceptionIterator.buildOfTree((Integer index, I o) -> (ExceptionIterator)itFunction.apply(o), comp, array, start, end);
    }

    public static <I, T extends Comparable<T>, E extends Exception> ExceptionIterator<T, E> buildOfTree(Function<I, ExceptionIterator<T, E>> itFunction, List<I> array, int start, int end) {
        return MergeExceptionIterator.buildOfTree((Integer index, I o) -> (ExceptionIterator)itFunction.apply(o), Comparable::compareTo, array, start, end);
    }

    public static <T extends Comparable<T>, E extends Exception> ExceptionIterator<T, E> buildOfTree(List<ExceptionIterator<T, E>> array, int start, int end) {
        return MergeExceptionIterator.buildOfTree(Function.identity(), Comparable::compareTo, array, start, end);
    }

    public static <T extends Comparable<? super T>, E extends Exception> ExceptionIterator<T, E> buildOfTree(List<ExceptionIterator<T, E>> array) {
        return MergeExceptionIterator.buildOfTree(Function.identity(), Comparable::compareTo, array, 0, array.size());
    }

    public static <I, T, E extends Exception> ExceptionIterator<T, E> buildOfTree(BiFunction<Integer, I, ExceptionIterator<T, E>> itFunction, Comparator<T> comp, List<I> array, int start, int end) {
        int length = end - start;
        if (length <= 0) {
            return ExceptionIterator.empty();
        }
        if (length == 1) {
            return itFunction.apply(start, array.get(start));
        }
        int mid = (start + end) / 2;
        return new MergeExceptionIterator<T, E>(MergeExceptionIterator.buildOfTree(itFunction, comp, array, start, mid), MergeExceptionIterator.buildOfTree(itFunction, comp, array, mid, end), comp);
    }

    public MergeExceptionIterator(ExceptionIterator<T, E> in1, ExceptionIterator<T, E> in2, Comparator<T> comp) {
        this.in1 = in1;
        this.in2 = in2;
        this.comp = comp;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.next != null) {
            return true;
        }
        if (this.prevE1 == null && this.in1.hasNext()) {
            this.prevE1 = this.in1.next();
        }
        if (this.prevE2 == null && this.in2.hasNext()) {
            this.prevE2 = this.in2.next();
        }
        if (this.prevE1 != null && this.prevE2 != null) {
            if (this.comp.compare(this.prevE1, this.prevE2) < 0) {
                this.next = this.prevE1;
                this.prevE1 = null;
            } else {
                this.next = this.prevE2;
                this.prevE2 = null;
            }
            return true;
        }
        if (this.prevE1 != null) {
            this.next = this.prevE1;
            this.prevE1 = null;
            return true;
        }
        if (this.prevE2 != null) {
            this.next = this.prevE2;
            this.prevE2 = null;
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        long s1 = this.in1.getSize();
        long s2 = this.in2.getSize();
        if (s1 == -1L || s2 == -1L) {
            return -1L;
        }
        return s2 + s1;
    }

    @Override
    public T next() throws E {
        if (!this.hasNext()) {
            return null;
        }
        T next = this.next;
        this.next = null;
        return next;
    }
}

