/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;

public class MapIterator<M, N>
implements Iterator<N> {
    private final MapWithIdFunction<M, N> mappingFunction;
    private final Iterator<M> base;
    private long index;

    public static <M, N> MapIterator<M, N> of(Iterator<M> base, Function<M, N> mappingFunction) {
        return new MapIterator<M, N>(base, mappingFunction);
    }

    public static <M, N> MapIterator<M, N> of(Iterator<M> base, MapWithIdFunction<M, N> mappingFunction) {
        return new MapIterator<M, N>(base, mappingFunction);
    }

    public MapIterator(Iterator<M> base, Function<M, N> mappingFunction) {
        this(base, (M m, long i) -> mappingFunction.apply(m));
    }

    public MapIterator(Iterator<M> base, MapWithIdFunction<M, N> mappingFunction) {
        this.base = base;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public N next() {
        return this.mappingFunction.apply(this.base.next(), this.index++);
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public ExceptionIterator<N, RuntimeException> asExceptionIterator() {
        return ExceptionIterator.of(this);
    }

    @FunctionalInterface
    public static interface MapWithIdFunction<T, E> {
        public E apply(T var1, long var2);
    }
}

