/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.MapIterator;

public class MapFilterIterator<M, N>
implements Iterator<N> {
    private final MapIterator.MapWithIdFunction<M, N> mappingFunction;
    private final Iterator<M> base;
    private long index;
    private N next;

    public static <M, N> MapFilterIterator<M, N> of(Iterator<M> base, Function<M, N> mappingFunction) {
        return new MapFilterIterator<M, N>(base, mappingFunction);
    }

    public static <M, N> MapFilterIterator<M, N> of(Iterator<M> base, MapIterator.MapWithIdFunction<M, N> mappingFunction) {
        return new MapFilterIterator<M, N>(base, mappingFunction);
    }

    private MapFilterIterator(Iterator<M> base, Function<M, N> mappingFunction) {
        this(base, (M m, long i) -> mappingFunction.apply(m));
    }

    private MapFilterIterator(Iterator<M> base, MapIterator.MapWithIdFunction<M, N> mappingFunction) {
        this.base = base;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.base.hasNext()) {
            N next = this.mappingFunction.apply(this.base.next(), this.index++);
            if (next == null) continue;
            this.next = next;
            return true;
        }
        return false;
    }

    @Override
    public N next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            N n = this.next;
            return n;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() {
        this.base.remove();
    }

    public ExceptionIterator<N, RuntimeException> asExceptionIterator() {
        return ExceptionIterator.of(this);
    }
}

