/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;

public class MapExceptionIterator<M, N, E extends Exception>
implements ExceptionIterator<N, E> {
    private final MapWithIdFunction<M, N, E> mappingFunction;
    private final ExceptionIterator<M, E> base;
    private long index;

    public MapExceptionIterator(ExceptionIterator<M, E> base, ExceptionFunction<M, N, E> mappingFunction) {
        this(base, (M m, long i) -> mappingFunction.apply(m));
    }

    public MapExceptionIterator(ExceptionIterator<M, E> base, MapWithIdFunction<M, N, E> mappingFunction) {
        this.base = base;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() throws E {
        return this.base.hasNext();
    }

    @Override
    public N next() throws E {
        return this.mappingFunction.apply(this.base.next(), this.index++);
    }

    @Override
    public void remove() throws E {
        this.base.remove();
    }

    @Override
    public long getSize() {
        return this.base.getSize();
    }

    @FunctionalInterface
    public static interface ExceptionFunction<M, N, E extends Exception> {
        public N apply(M var1) throws E;
    }

    @FunctionalInterface
    public static interface MapWithIdFunction<M, N, E extends Exception> {
        public N apply(M var1, long var2) throws E;
    }
}

