/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.List;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;

public class ListTripleIDIterator
implements IteratorTripleID {
    private final List<TripleID> triplesList;
    private int pos;
    private long lastPosition;

    public ListTripleIDIterator(List<TripleID> triplesList) {
        this.triplesList = triplesList;
        this.pos = 0;
    }

    public boolean hasNext() {
        return this.pos < this.triplesList.size();
    }

    public TripleID next() {
        this.lastPosition = this.pos;
        return this.triplesList.get(this.pos++);
    }

    public boolean hasPrevious() {
        return this.pos > 0;
    }

    public TripleID previous() {
        TripleID tripleID = this.triplesList.get(--this.pos);
        this.lastPosition = this.pos;
        return tripleID;
    }

    public void goToStart() {
        this.pos = 0;
    }

    public long estimatedNumResults() {
        return this.triplesList.size();
    }

    public ResultEstimationType numResultEstimation() {
        return ResultEstimationType.EXACT;
    }

    public boolean canGoTo() {
        return true;
    }

    public void goTo(long pos) {
        this.pos = (int)pos;
    }

    public TripleComponentOrder getOrder() {
        return TripleComponentOrder.Unknown;
    }

    public long getLastTriplePosition() {
        return this.lastPosition;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

