/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.string.ByteString;

public abstract class IndexNodeDeltaMergeExceptionIterator<E extends Exception>
implements ExceptionIterator<IndexedNode, E> {
    protected IndexedNode next;
    protected int delta;
    protected int pivot;

    public static <I, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(Function<I, IndexNodeDeltaFetcher<E>> itFunction, I[] array, int length) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree(itFunction, array, 0, length);
    }

    public static <I, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(Function<I, IndexNodeDeltaFetcher<E>> itFunction, I[] array, int start, int end) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree(itFunction, Arrays.asList(array), start, end);
    }

    public static <I, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(Function<I, IndexNodeDeltaFetcher<E>> itFunction, List<I> array, int start, int end) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree0(itFunction, array, start, end);
    }

    public static <I extends IndexNodeDeltaFetcher<E>, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(I[] array, int length) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree((I i) -> i, array, 0, length);
    }

    public static <I extends IndexNodeDeltaFetcher<E>, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(I[] array) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree((I i) -> i, array, 0, array.length);
    }

    public static <I extends IndexNodeDeltaFetcher<E>, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(I[] array, int start, int end) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree((I i) -> i, Arrays.asList(array), start, end);
    }

    public static <I extends IndexNodeDeltaFetcher<E>, E extends Exception> ExceptionIterator<IndexedNode, E> buildOfTree(List<I> array, int start, int end) {
        return IndexNodeDeltaMergeExceptionIterator.buildOfTree((I i) -> i, array, start, end);
    }

    private static <I, E extends Exception> IndexNodeDeltaMergeExceptionIterator<E> buildOfTree0(Function<I, IndexNodeDeltaFetcher<E>> itFunction, List<I> array, int start, int end) {
        int length = end - start;
        if (length <= 0) {
            return new ExceptionIteratorEmpty();
        }
        if (length == 1) {
            return new ExceptionIteratorMap<E>(itFunction.apply(array.get(start)));
        }
        int mid = (start + end) / 2;
        return new ExceptionIteratorMerger<E>(IndexNodeDeltaMergeExceptionIterator.buildOfTree0(itFunction, array, start, mid), IndexNodeDeltaMergeExceptionIterator.buildOfTree0(itFunction, array, mid, end));
    }

    static int compareToDelta(int delta, IndexedNode node1, IndexedNode node2) {
        ByteString cs1 = node1.getNode();
        ByteString cs2 = node2.getNode();
        int len = Math.min(cs1.length(), cs2.length());
        for (int i = delta; i < len; ++i) {
            char b;
            char a = cs1.charAt(i);
            if (a == (b = cs2.charAt(i))) continue;
            return a > b ? -(i + 1) : i + 1;
        }
        return cs1.length() != len ? -(len + 1) : len + 1;
    }

    private IndexNodeDeltaMergeExceptionIterator() {
    }

    @Override
    public boolean hasNext() throws E {
        if (this.next != null) {
            return true;
        }
        this.fetchNext();
        return this.peekNext() != null;
    }

    @Override
    public IndexedNode next() throws E {
        if (!this.hasNext()) {
            return null;
        }
        try {
            IndexedNode indexedNode = this.next;
            return indexedNode;
        }
        finally {
            this.next = null;
        }
    }

    public IndexedNode peekNext() {
        return this.next;
    }

    public int getDelta() {
        return this.delta;
    }

    public abstract void fetchNext() throws E;

    public void printMergeTree() {
        this.printMergeTree(0);
    }

    protected abstract void printMergeTree(int var1);

    static class ExceptionIteratorMerger<E extends Exception>
    extends IndexNodeDeltaMergeExceptionIterator<E> {
        private final IndexNodeDeltaMergeExceptionIterator<E> it1;
        private final IndexNodeDeltaMergeExceptionIterator<E> it2;
        private IndexedNode last1;
        private IndexedNode last2;
        private boolean send1;

        public ExceptionIteratorMerger(IndexNodeDeltaMergeExceptionIterator<E> it1, IndexNodeDeltaMergeExceptionIterator<E> it2) {
            this.it1 = it1;
            this.it2 = it2;
        }

        @Override
        public void fetchNext() throws E {
            int delta2;
            if (this.last1 == null) {
                this.it1.fetchNext();
                this.last1 = this.it1.peekNext();
            }
            if (this.last2 == null) {
                this.it2.fetchNext();
                this.last2 = this.it2.peekNext();
            }
            if (this.last1 == null || this.last2 == null) {
                if (this.last1 != null) {
                    this.next = this.last1;
                    this.last1 = null;
                } else if (this.last2 != null) {
                    this.next = this.last2;
                    this.last2 = null;
                } else {
                    this.next = null;
                }
                return;
            }
            int delta1 = this.it1.getDelta();
            int minDelta = Math.min(delta1, delta2 = this.it2.getDelta());
            if (this.pivot < minDelta) {
                if (this.send1) {
                    this.next = this.last1;
                    this.last1 = null;
                } else {
                    this.next = this.last2;
                    this.last2 = null;
                }
                return;
            }
            int deltaCompare = ExceptionIteratorMerger.compareToDelta(minDelta, this.last1, this.last2);
            if (deltaCompare < 0) {
                this.next = this.last2;
                this.pivot = -deltaCompare - 1;
                this.delta = !this.send1 ? delta2 : 0;
                this.last2 = null;
                this.send1 = false;
            } else {
                this.next = this.last1;
                this.pivot = deltaCompare - 1;
                this.delta = this.send1 ? delta1 : 0;
                this.last1 = null;
                this.send1 = true;
            }
        }

        @Override
        protected void printMergeTree(int depth) {
            System.out.println("  ".repeat(depth) + "Merge");
            this.it1.printMergeTree(depth + 1);
            this.it2.printMergeTree(depth + 1);
        }
    }

    static class ExceptionIteratorEmpty<E extends Exception>
    extends IndexNodeDeltaMergeExceptionIterator<E> {
        ExceptionIteratorEmpty() {
        }

        @Override
        public void fetchNext() {
        }

        @Override
        protected void printMergeTree(int depth) {
            System.out.println("  ".repeat(depth) + "Empty");
        }
    }

    static class ExceptionIteratorMap<E extends Exception>
    extends IndexNodeDeltaMergeExceptionIterator<E> {
        private final IndexNodeDeltaFetcher<E> iterator;

        public ExceptionIteratorMap(IndexNodeDeltaFetcher<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void fetchNext() throws E {
            this.next = this.iterator.fetchNode();
            this.delta = this.iterator.lastDelta();
        }

        @Override
        protected void printMergeTree(int depth) {
            System.out.println("  ".repeat(depth) + "Leaf[" + this.iterator + "]");
        }
    }

    public static interface IndexNodeDeltaFetcher<E extends Exception> {
        public IndexedNode fetchNode() throws E;

        public int lastDelta() throws E;
    }
}

