/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.triples.TripleString;

public class FluxStopTripleStringIterator
implements Iterator<TripleString> {
    private TripleString next;
    private final Iterator<TripleString> iterator;
    private final RDFFluxStop fluxStop;
    private boolean stop;

    public FluxStopTripleStringIterator(Iterator<TripleString> iterator, RDFFluxStop fluxStop) {
        this.iterator = iterator;
        this.fluxStop = fluxStop;
    }

    @Override
    public boolean hasNext() {
        if (this.stop) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        if (!this.iterator.hasNext()) {
            return false;
        }
        this.next = this.iterator.next();
        if (!this.fluxStop.canHandle(this.next)) {
            this.stop = true;
            return false;
        }
        return true;
    }

    public boolean hasNextFlux() {
        this.stop = false;
        this.fluxStop.restart();
        return this.hasNext();
    }

    @Override
    public TripleString next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            TripleString tripleString = this.next;
            return tripleString;
        }
        finally {
            this.next = null;
        }
    }
}

