/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.MapIterator;

public class FilterMapExceptionIterator<M, N, E extends Exception>
implements ExceptionIterator<N, E> {
    private final MapWithIdFunction<M, N, E> mappingFunction;
    private final ExceptionIterator<M, E> base;
    private long index;
    private N next;

    public static <M, N> MapIterator<M, N> of(Iterator<M> base, Function<M, N> mappingFunction) {
        return new MapIterator<M, N>(base, mappingFunction);
    }

    public static <M, N> MapIterator<M, N> of(Iterator<M> base, MapIterator.MapWithIdFunction<M, N> mappingFunction) {
        return new MapIterator<M, N>(base, mappingFunction);
    }

    public FilterMapExceptionIterator(ExceptionIterator<M, E> base, ExceptionFunction<M, N, E> mappingFunction) {
        this(base, (M m, long i) -> mappingFunction.apply(m));
    }

    public FilterMapExceptionIterator(ExceptionIterator<M, E> base, MapWithIdFunction<M, N, E> mappingFunction) {
        this.base = base;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() throws E {
        if (this.next != null) {
            return true;
        }
        while (this.base.hasNext()) {
            N next = this.mappingFunction.apply(this.base.next(), this.index++);
            if (next == null) continue;
            this.next = next;
            return true;
        }
        return false;
    }

    @Override
    public N next() throws E {
        if (!this.hasNext()) {
            return null;
        }
        try {
            N n = this.next;
            return n;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public void remove() throws E {
        this.base.remove();
    }

    @FunctionalInterface
    public static interface ExceptionFunction<M, N, E extends Exception> {
        public N apply(M var1) throws E;
    }

    @FunctionalInterface
    public static interface MapWithIdFunction<M, N, E extends Exception> {
        public N apply(M var1, long var2) throws E;
    }
}

