/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.io.IOException;
import java.util.Iterator;
import org.rdfhdt.hdt.iterator.utils.FileChunkIterator;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.string.ByteString;

public class FileTripleIterator
extends FileChunkIterator<TripleString> {
    public static long estimateSize(TripleString tripleString) {
        try {
            return ByteString.of(tripleString.asNtriple()).getBuffer().length;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't estimate the size of the triple " + tripleString, e);
        }
    }

    public FileTripleIterator(Iterator<TripleString> it, long maxSize) {
        super(it, maxSize, FileTripleIterator::estimateSize);
    }
}

