/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;

public class FileChunkIterator<E>
implements Iterator<E> {
    private final ToLongFunction<E> estimationFunction;
    private final Iterator<E> it;
    private final long maxSize;
    private long totalSize = 0L;
    private long currentSize = 0L;
    private E next;
    private boolean stop = false;

    public FileChunkIterator(Iterator<E> it, long maxSize, ToLongFunction<E> estimationFunction) {
        this.it = it;
        this.maxSize = maxSize;
        this.estimationFunction = estimationFunction;
    }

    @Override
    public boolean hasNext() {
        if (this.stop) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        if (this.it.hasNext()) {
            this.next = this.it.next();
            long estimation = this.estimationFunction.applyAsLong(this.next);
            this.totalSize += estimation;
            if (this.currentSize + estimation >= this.maxSize) {
                this.stop = true;
                this.currentSize = estimation;
                return false;
            }
            this.currentSize += estimation;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            return null;
        }
        E t = this.next;
        this.next = null;
        return t;
    }

    @Override
    public void remove() {
        this.it.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.it.forEachRemaining(action);
    }

    public void forceNewFile() {
        long estimation = this.next != null ? this.estimationFunction.applyAsLong(this.next) : 0L;
        this.currentSize = estimation;
        this.stop = true;
    }

    public boolean hasNewFile() {
        this.stop = false;
        return this.hasNext();
    }

    public long getTotalSize() {
        return this.totalSize;
    }
}

