/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.function.Function;
import org.rdfhdt.hdt.iterator.utils.MapIterator;

public abstract class FetcherIterator<T>
implements Iterator<T> {
    private T next;

    protected FetcherIterator() {
    }

    protected abstract T getNext();

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.getNext();
        return this.next != null;
    }

    @Override
    public T next() {
        try {
            T t = this.peek();
            return t;
        }
        finally {
            this.next = null;
        }
    }

    public T peek() {
        if (this.hasNext()) {
            return this.next;
        }
        return null;
    }

    public <M> Iterator<M> map(Function<T, M> mappingFunction) {
        return new MapIterator<T, M>(this, mappingFunction);
    }
}

