/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.rdfhdt.hdt.iterator.utils.FilterMapExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.MapExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.NotificationExceptionIterator;
import org.rdfhdt.hdt.listener.ProgressListener;

public interface ExceptionIterator<T, E extends Exception> {
    public static <T, E extends Exception> ExceptionIterator<T, E> of(final Iterator<T> it) {
        return new ExceptionIterator<T, E>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public static <T, E extends Exception> ExceptionIterator<T, E> empty() {
        return ExceptionIterator.of(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                return null;
            }
        });
    }

    public boolean hasNext() throws E;

    public T next() throws E;

    default public void remove() throws E {
        throw new UnsupportedOperationException("remove");
    }

    default public void forEachRemaining(ExceptionConsumer<? super T, E> action) throws E {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.consume(this.next());
        }
    }

    default public <M> ExceptionIterator<M, E> map(MapExceptionIterator.ExceptionFunction<T, M, E> mappingFunc) {
        return new MapExceptionIterator<T, M, E>(this, mappingFunc);
    }

    default public <M> ExceptionIterator<M, E> map(MapExceptionIterator.MapWithIdFunction<T, M, E> mappingFunc) {
        return new MapExceptionIterator<T, M, E>(this, mappingFunc);
    }

    default public <M> ExceptionIterator<M, E> mapFiltered(FilterMapExceptionIterator.ExceptionFunction<T, M, E> mappingFunc) {
        return new FilterMapExceptionIterator<T, M, E>(this, mappingFunc);
    }

    default public <M> ExceptionIterator<M, E> mapFiltered(FilterMapExceptionIterator.MapWithIdFunction<T, M, E> mappingFunc) {
        return new FilterMapExceptionIterator<T, M, E>(this, mappingFunc);
    }

    default public ExceptionIterator<T, E> notif(long estimatedSize, long maxSplit, String message, ProgressListener listener) {
        return new NotificationExceptionIterator(this, estimatedSize, Math.max(maxSplit, estimatedSize / 10000L), message, listener);
    }

    default public Iterator<T> asIterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                try {
                    return ExceptionIterator.this.hasNext();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            @Override
            public T next() {
                try {
                    return ExceptionIterator.this.next();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                try {
                    ExceptionIterator.this.forEachRemaining(action::accept);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                try {
                    ExceptionIterator.this.remove();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        };
    }

    default public long getSize() {
        return -1L;
    }

    @FunctionalInterface
    public static interface ExceptionConsumer<T, E extends Exception> {
        public void consume(T var1) throws E;
    }
}

