/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class CombinedIterator<T>
implements Iterator<T> {
    private final Iterator<T> left;
    private final Iterator<T> right;
    private T next;

    public static <T> Iterator<T> combine(List<Iterator<T>> iterators) {
        Objects.requireNonNull(iterators, "iterators can't be null");
        return CombinedIterator.combine(iterators, 0, iterators.size());
    }

    private static <T> Iterator<T> combine(List<Iterator<T>> iterators, int start, int end) {
        int len = end - start;
        if (len <= 0) {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    return null;
                }
            };
        }
        if (len == 1) {
            return iterators.get(start);
        }
        int mid = (end + start) / 2;
        return new CombinedIterator<T>(CombinedIterator.combine(iterators, start, mid), CombinedIterator.combine(iterators, mid, end));
    }

    private CombinedIterator(Iterator<T> left, Iterator<T> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.left.hasNext()) {
            this.next = this.left.next();
        } else if (this.right.hasNext()) {
            this.next = this.right.next();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            T t = this.next;
            return t;
        }
        finally {
            this.next = null;
        }
    }
}

