/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.iterator.utils;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class AsyncIteratorFetcher<E>
implements Supplier<E> {
    private final Iterator<E> iterator;
    private final Lock lock = new ReentrantLock();
    private boolean end;

    public AsyncIteratorFetcher(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public E get() {
        this.lock.lock();
        try {
            if (this.iterator.hasNext()) {
                E e = this.iterator.next();
                return e;
            }
            this.end = true;
            E e = null;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEnd() {
        return this.end;
    }
}

